/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.Client.screens;

import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.utils.PlayerRenderExtension;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CarryPositionScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"gui.holdmetight.carry_position_screen");
    private static final ResourceLocation BACKGROUND = new ResourceLocation("holdmetight", "textures/gui/carry_position_item_bg.png");
    private static final ResourceLocation CIRCLE = new ResourceLocation("holdmetight", "textures/gui/carry_screen_circle.png");
    private static final Component ROT_BUTTON = Component.m_237115_((String)"gui.holdmetight.size_remote.button.rotate_button");
    private static final Component CUSTOM_INPUT_FIELD = Component.m_237115_((String)"gui.holdmetight.size_remote.field.custom_input_field");
    private static final Component CUSTOM_INPUT_FIELD_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_remote.field.custom_input_field_tooltip");
    private final double[] chestPreset = new double[]{0.0, 0.0, 0.0, 0.0};
    private final double[] mouthPreset = new double[]{0.0, 0.0, 0.0, 0.0};
    private final int imageWidth;
    private final int imageHeight;
    private int leftPos;
    private int rightPos;
    private int topPos;
    private int bottomPos;
    private int centerHorizonalPos;
    private int centerVerticalPos;
    private Player user;
    private PlayerCarry userCarry;
    private int rotation = 0;
    private double forwardsBackwardsMultiplier = 0.0;
    private double vertical = 0.0;
    private double leftRight = 0.0;
    private boolean topDownView = true;
    private Button setButton;
    private EditBox customInputField;

    public CarryPositionScreen(Player user) {
        super(TITLE);
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.user = user;
        this.userCarry = PlayerCarryProvider.getPlayerCarryCapability(user);
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.rightPos = this.f_96543_ - this.leftPos;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.bottomPos = this.f_96544_ - this.topPos;
        this.centerHorizonalPos = (this.leftPos + this.rightPos) / 2;
        this.centerVerticalPos = (this.topPos + this.bottomPos) / 2;
        this.setButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ROT_BUTTON, this::handleSetButton).m_252987_(this.leftPos + 8, this.topPos + 200, 76, 20).m_257505_(Tooltip.m_257550_((Component)ROT_BUTTON)).m_253136_());
        this.initCustomInputField();
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        PlayerRenderExtension rend = (PlayerRenderExtension)this.user;
        if (rend != null) {
            rend.setMenu(true);
            if (this.topDownView) {
                this.renderEntityInInventoryFollowsAngle(graphics, this.centerHorizonalPos, this.centerVerticalPos, 60, 0.0f, -4.5f, (LivingEntity)((Player)rend));
            } else {
                this.renderEntityInInventoryFollowsAngle(graphics, this.centerHorizonalPos, this.centerVerticalPos + 60, 60, 270.0f, 0.0f, (LivingEntity)((Player)rend));
            }
            rend.setMenu(false);
        }
        this.renderTopDown(graphics, mouseX, mouseY, partialTicks);
    }

    private void renderTopDown(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int xpos = this.centerHorizonalPos;
        int ypos = this.centerVerticalPos;
        double xOffset = Math.cos(Math.toRadians((this.rotation - 90) % 360));
        double yOffset = Math.sin(Math.toRadians((this.rotation - 90) % 360));
        this.forwardsBackwardsMultiplier = 1.0;
        xpos = (int)((double)xpos + xOffset * 64.0 * this.forwardsBackwardsMultiplier);
        ypos = (int)((double)ypos + yOffset * 64.0 * this.forwardsBackwardsMultiplier);
        graphics.m_280509_(xpos - 2, ypos - 2, xpos + 2, ypos + 2, -65536);
    }

    private void handleSetButton(Button button) {
        String rot = this.customInputField.m_94155_();
        boolean bl = this.topDownView = !this.topDownView;
        if (rot != null && !rot.isEmpty()) {
            this.rotation = Integer.parseInt(rot) % 360;
        }
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics graphics, int xPos, int yPos, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        float f = angleXComponent;
        float f1 = angleYComponent;
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = f;
        entity.m_146922_(f);
        entity.m_146926_(0.0f);
        entity.f_20885_ = f;
        entity.f_20886_ = 0.0f;
        InventoryScreen.m_280432_((GuiGraphics)graphics, (int)xPos, (int)yPos, (int)scale, (Quaternionf)quaternionf, (Quaternionf)quaternionf1, (LivingEntity)entity);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }

    private void initCustomInputField() {
        this.customInputField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 48, this.bottomPos - 80, 80, 20, CUSTOM_INPUT_FIELD));
        Predicate<String> filter = new Predicate<String>(){

            @Override
            public boolean test(String t) {
                if (!t.trim().equals(t)) {
                    return false;
                }
                if (t != null && t.isEmpty()) {
                    return true;
                }
                String checkFinalChar = t.substring(t.length() - 1);
                if (checkFinalChar.equals("f") || checkFinalChar.equals("d")) {
                    return false;
                }
                try {
                    Integer.parseInt(t);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.customInputField.m_94153_((Predicate)filter);
        this.customInputField.m_94144_(Integer.toString(this.userCarry.getCarryPosition().RotationOffset));
        Tooltip t = Tooltip.m_257563_((Component)CUSTOM_INPUT_FIELD_TOOLTIP, (Component)CUSTOM_INPUT_FIELD_TOOLTIP);
        this.customInputField.m_257544_(t);
    }
}

