/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.Client.screens;

import com.ricardthegreat.holdmetight.carry.CarryPosition;
import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;

public class CarryPositionWheel
extends Screen {
    private static final Component TITLE = Component.m_237113_((String)"Carry selection screen");
    private static final Component CARRY_POS_SELECTED = Component.m_237115_((String)"message.holdmetight.carry_key_pressed");
    private final int imageWidth;
    private final int imageHeight;
    private Player player;
    private int leftPos;
    private int rightPos;
    private int topPos;
    private int bottomPos;
    private int centerHorizonalPos;
    private int centerVerticalPos;
    private int internalRadius = 50;
    private int externalRadius = 100;
    private int verticalOffset = 30;
    private ArrayList<CarryPosition> defaultPositions;
    private ArrayList<CarryPosition> customPositions;
    private ArrayList<CarryPosition> currentListedPositions;
    private int numSlices;
    private int page = 0;
    private boolean rightArrowVisible;
    private boolean leftArrowVisible;

    public CarryPositionWheel(Player player) {
        super(TITLE);
        this.imageWidth = 176;
        this.imageHeight = 256;
        this.player = player;
        this.defaultPositions = PlayerCarryProvider.getPlayerCarryCapability(player).getAllCarryPositions().get(0);
        this.customPositions = PlayerCarryProvider.getPlayerCarryCapability(player).getAllCarryPositions().get(1);
        this.currentListedPositions = this.defaultPositions;
        this.numSlices = this.currentListedPositions.size();
        this.leftArrowVisible = false;
        if (this.customPositions.size() > 0) {
            this.rightArrowVisible = true;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.rightPos = this.f_96543_ - this.leftPos;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.bottomPos = this.f_96544_ - this.topPos;
        this.centerHorizonalPos = (this.leftPos + this.rightPos) / 2;
        this.centerVerticalPos = (this.topPos + this.bottomPos) / 2;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawRadialSelector(mouseX, mouseY, graphics);
        this.drawArrows(mouseX, mouseY, graphics);
    }

    private void drawArrows(int mouseX, int mouseY, GuiGraphics graphics) {
        if (this.rightArrowVisible) {
            if (this.hoveringRightArrow(mouseX, mouseY)) {
                this.drawArrow(7, this.verticalOffset - 2, 17, 9, 6, -1, false, graphics);
                this.drawArrow(8, this.verticalOffset - 1, 17, 7, 5, -16777216, false, graphics);
            } else {
                this.drawArrow(8, this.verticalOffset - 1, 15, 7, 4, -1, false, graphics);
                this.drawArrow(9, this.verticalOffset, 15, 5, 3, -16777216, false, graphics);
            }
        }
        if (this.leftArrowVisible) {
            if (this.hoveringLeftArrow(mouseX, mouseY)) {
                this.drawArrow(-7, this.verticalOffset - 2, 17, 9, 6, -1, true, graphics);
                this.drawArrow(-8, this.verticalOffset - 1, 17, 7, 5, -16777216, true, graphics);
            } else {
                this.drawArrow(-8, this.verticalOffset - 1, 15, 7, 4, -1, true, graphics);
                this.drawArrow(-9, this.verticalOffset, 15, 5, 3, -16777216, true, graphics);
            }
        }
    }

    private void drawArrow(int x, int y, int length, int height, int pointHeight, int colour, boolean backwards, GuiGraphics graphics) {
        int direction = 1;
        if (backwards) {
            length = -length;
            direction = -1;
        }
        graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos + y, this.centerHorizonalPos + x + length, this.centerVerticalPos + height + y, colour);
        int tip = height / 2;
        for (int i = -pointHeight; i <= tip; ++i) {
            graphics.m_280509_(this.centerHorizonalPos + x + length, this.centerVerticalPos + y + i, this.centerHorizonalPos + x + length + 1, this.centerVerticalPos + y + height - i, colour);
            length += direction;
        }
    }

    private void drawRadialSelector(int mouseX, int mouseY, GuiGraphics graphics) {
        int relativeMouseY = mouseY - this.centerVerticalPos - this.verticalOffset;
        int relativeMouseX = mouseX - this.centerHorizonalPos;
        if (this.findSlice(relativeMouseY, relativeMouseX) >= 0) {
            this.fillCircleSection(graphics, -65536, this.findSlice(relativeMouseY, relativeMouseX));
        } else {
            this.fillCircleSection(graphics, -65536);
        }
        this.renderHemisphere(this.internalRadius, graphics, -1);
        this.renderHemisphere(this.externalRadius, graphics, -1);
        this.genLineSeperations(graphics);
        this.findTextPositions(graphics);
        graphics.m_280509_(this.centerHorizonalPos + this.internalRadius, this.centerVerticalPos + this.verticalOffset, this.centerHorizonalPos + this.externalRadius, this.centerVerticalPos + 1 + this.verticalOffset, -1);
        graphics.m_280509_(this.centerHorizonalPos - this.internalRadius, this.centerVerticalPos + this.verticalOffset, this.centerHorizonalPos - this.externalRadius, this.centerVerticalPos + 1 + this.verticalOffset, -1);
    }

    private void findTextPositions(GuiGraphics graphics) {
        for (int i = 0; i < this.numSlices; ++i) {
            double angle = 180 / this.numSlices;
            angle = angle / 2.0 + angle * (double)i;
            int[] firstCoords = this.genAngles(this.externalRadius, angle);
            ArrayList<int[]> coords = this.midPointLineGeneration(0, 0, -firstCoords[1], firstCoords[0]);
            int half = coords.size() / 2;
            graphics.m_280137_(this.f_96547_, this.currentListedPositions.get((int)i).posName, this.centerHorizonalPos + coords.get(half)[0], this.centerVerticalPos + coords.get(half)[1] + this.verticalOffset, 0xDDDDDD);
        }
    }

    private void genLineSeperations(GuiGraphics graphics) {
        for (int i = 1; i < this.numSlices; ++i) {
            double angle = 180 / this.numSlices;
            int[] firstCoords = this.genAngles(this.externalRadius, angle *= (double)i);
            ArrayList<int[]> coords = this.midPointLineGeneration(0, 0, -firstCoords[1], firstCoords[0]);
            for (int j = 0; j < coords.size(); ++j) {
                graphics.m_280509_(this.centerHorizonalPos + coords.get(j)[0], this.centerVerticalPos + coords.get(j)[1] + this.verticalOffset, this.centerHorizonalPos + 1 + coords.get(j)[0], this.centerVerticalPos + 1 + coords.get(j)[1] + this.verticalOffset, -1);
            }
        }
    }

    private int[] genAngles(int radius, double angle) {
        double x = (double)radius * Math.cos(Math.toRadians(angle));
        double y = (double)radius * Math.sin(Math.toRadians(angle));
        return new int[]{(int)x, (int)y};
    }

    private ArrayList<int[]> midPointLineGeneration(int y1, int x1, int y2, int x2) {
        boolean negX = false;
        boolean negY = false;
        boolean swapped = false;
        if (x2 < x1) {
            x2 = x1 + (x1 - x2);
            negX = true;
        }
        if (y2 < y1) {
            y2 = y1 + (y1 - y2);
            negY = true;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (y2 > x2) {
            int temp = y1;
            y1 = x1;
            x1 = temp;
            temp = y2;
            y2 = x2;
            x2 = temp;
            dx = x2 - x1;
            dy = y2 - y1;
            swapped = true;
        }
        int d = dy - dx / 2;
        int x = x1;
        int y = y1;
        ArrayList<int[]> coords = new ArrayList<int[]>();
        while (x < x2) {
            d = d < 0 ? (d += dy) : (d += dy - dx);
            int tempX = ++x;
            int tempY = ++y;
            if (swapped) {
                int temp = tempX;
                tempX = tempY;
                tempY = temp;
            }
            if (negX) {
                tempX = x1 - (tempX - x1);
            }
            if (negY) {
                tempY = y1 - (tempY - y1);
            }
            if (!this.inCirclePerimeter(tempY, tempX, this.externalRadius) || this.inCirclePerimeter(tempY, tempX, this.internalRadius)) continue;
            coords.add(new int[]{tempX, tempY});
        }
        return coords;
    }

    private void renderHemisphere(int radius, GuiGraphics graphics, int colour) {
        int x = 0;
        int y = radius;
        this.fillTopSemicirclePixels(y, x, graphics, colour);
        this.fillTopSemicirclePixels(x, y, graphics, colour);
        while (y > x) {
            if (!this.inCirclePerimeter((double)y - 0.5, x + 1, radius)) {
                --y;
            }
            this.fillTopSemicirclePixels(y, ++x, graphics, colour);
            this.fillTopSemicirclePixels(x, y, graphics, colour);
        }
    }

    private void fillCircleSection(GuiGraphics graphics, int colour) {
        for (int x = -this.externalRadius; x < this.externalRadius; ++x) {
            int y = 1;
            int min = 0;
            while (this.inCirclePerimeter(y, x, this.internalRadius)) {
                ++min;
                ++y;
            }
            int max = min;
            while (this.inCirclePerimeter(y, x, this.externalRadius)) {
                ++max;
                ++y;
            }
            graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos - min + this.verticalOffset, this.centerHorizonalPos + x + 1, this.centerVerticalPos - max + this.verticalOffset, 0x55FF0000);
        }
    }

    private void fillCircleSection(GuiGraphics graphics, int colour, int slice) {
        for (int x = -this.externalRadius; x < this.externalRadius; ++x) {
            int y = 1;
            int min = 0;
            while (this.inCirclePerimeter(y, x, this.internalRadius)) {
                ++min;
                ++y;
            }
            int max = min;
            int sliceMin = min;
            int sliceMax = max;
            while (this.inCirclePerimeter(y, x, this.externalRadius)) {
                if (this.inSlice(-y, x, slice)) {
                    if (sliceMax < max) {
                        sliceMax = max;
                    }
                    if (sliceMin <= min) {
                        ++min;
                        ++max;
                    }
                    ++sliceMax;
                } else {
                    if (max < sliceMax) {
                        max = sliceMax;
                    }
                    if (min <= sliceMin) {
                        ++sliceMin;
                        ++sliceMax;
                    }
                    ++max;
                }
                ++y;
            }
            graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos - min + this.verticalOffset, this.centerHorizonalPos + x + 1, this.centerVerticalPos - max + this.verticalOffset, 0x55FF0000);
            graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos - sliceMin + this.verticalOffset, this.centerHorizonalPos + x + 1, this.centerVerticalPos - sliceMax + this.verticalOffset, -65536);
        }
    }

    private void renderCircle(int radius, GuiGraphics graphics) {
        int x = 0;
        int y = radius;
        this.fillCirclePixels(y, x, graphics);
        this.fillCirclePixels(x, y, graphics);
        while (y > x) {
            if (!this.inCirclePerimeter((double)y - 0.5, x + 1, radius)) {
                --y;
            }
            this.fillCirclePixels(y, ++x, graphics);
            this.fillCirclePixels(x, y, graphics);
        }
    }

    private void fillTopSemicirclePixels(int y, int x, GuiGraphics graphics, int colour) {
        graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos - y + this.verticalOffset, this.centerHorizonalPos + x + 1, this.centerVerticalPos - y + 1 + this.verticalOffset, colour);
        graphics.m_280509_(this.centerHorizonalPos - x, this.centerVerticalPos - y + this.verticalOffset, this.centerHorizonalPos - x + 1, this.centerVerticalPos - y + 1 + this.verticalOffset, colour);
    }

    private void fillCirclePixels(int y, int x, GuiGraphics graphics) {
        graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos + y, this.centerHorizonalPos + x + 1, this.centerVerticalPos + y + 1, -1);
        graphics.m_280509_(this.centerHorizonalPos - x, this.centerVerticalPos + y, this.centerHorizonalPos - x + 1, this.centerVerticalPos + y + 1, -1);
        graphics.m_280509_(this.centerHorizonalPos + x, this.centerVerticalPos - y, this.centerHorizonalPos + x + 1, this.centerVerticalPos - y + 1, -1);
        graphics.m_280509_(this.centerHorizonalPos - x, this.centerVerticalPos - y, this.centerHorizonalPos - x + 1, this.centerVerticalPos - y + 1, -1);
    }

    private boolean inCirclePerimeter(double y, double x, int radius) {
        double i = y * y + x * x - (double)(radius * radius);
        return !(i > 0.0);
    }

    private int findSlice(double y, double x) {
        int slice = -1;
        if (this.inCirclePerimeter(y, x, this.externalRadius) && !this.inCirclePerimeter(y, x, this.internalRadius)) {
            for (int i = 0; i < this.numSlices; ++i) {
                if (!this.inSlice(y, x, i)) continue;
                slice = i;
            }
        }
        return slice;
    }

    private boolean inSlice(double y, double x, int slice) {
        double angle = 180 / this.numSlices;
        angle = Math.toRadians(angle);
        double A = Math.atan2(y - 0.0, x - 0.0);
        double startingAngle = 0.0 - angle * (double)slice;
        double endingAngle = -angle - angle * (double)slice;
        return A < startingAngle && A > endingAngle;
    }

    private void updateListedPositions() {
        if (this.page == 0) {
            this.currentListedPositions = this.defaultPositions;
        } else {
            ArrayList<CarryPosition> positions = new ArrayList<CarryPosition>();
            for (int i = 0; i < 5 && i < this.customPositions.size(); ++i) {
                int selectionOffset = i + (this.page - 1) * 5;
                positions.add(this.customPositions.get(selectionOffset));
            }
            this.currentListedPositions = positions;
        }
        this.updateNumSlices();
        this.updateArrows();
    }

    private void updateNumSlices() {
        this.numSlices = this.currentListedPositions.size();
    }

    private void updateArrows() {
        if (this.page == 0) {
            this.leftArrowVisible = false;
            this.rightArrowVisible = true;
        } else {
            this.leftArrowVisible = true;
            this.rightArrowVisible = this.customPositions.size() > this.page * 5;
        }
    }

    private boolean hoveringLeftArrow(double x, double y) {
        int y1 = this.centerVerticalPos + this.verticalOffset - 2;
        int y2 = this.centerVerticalPos + this.verticalOffset - 2 + 9;
        int x1 = this.centerHorizonalPos - 7;
        int x2 = this.centerHorizonalPos - 7 - 22;
        return y > (double)y1 && y < (double)y2 && x < (double)x1 && x > (double)x2;
    }

    private boolean hoveringRightArrow(double x, double y) {
        int y1 = this.centerVerticalPos + this.verticalOffset - 2;
        int y2 = this.centerVerticalPos + this.verticalOffset - 2 + 9;
        int x1 = this.centerHorizonalPos + 7;
        int x2 = this.centerHorizonalPos + 7 + 22;
        return y > (double)y1 && y < (double)y2 && x > (double)x1 && x < (double)x2;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        int posSelection = this.findSlice(y - (double)this.centerVerticalPos - (double)this.verticalOffset, x - (double)this.centerHorizonalPos);
        if (posSelection >= 0) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            CarryPosition selectedPos = this.currentListedPositions.get(posSelection);
            PlayerCarry playerCarry = PlayerCarryProvider.getPlayerCarryCapability(this.player);
            if (this.page == 0) {
                playerCarry.setCarryPosition(false, posSelection);
            } else {
                playerCarry.setCarryPosition(true, posSelection);
            }
            this.player.m_5661_((Component)Component.m_237113_((String)(CARRY_POS_SELECTED.getString() + selectedPos.posName)), true);
            playerCarry.setShouldSyncSimple(true);
        }
        if (this.rightArrowVisible && this.hoveringRightArrow(x, y)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            ++this.page;
            this.updateListedPositions();
        }
        if (this.leftArrowVisible && this.hoveringLeftArrow(x, y)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            --this.page;
            this.updateListedPositions();
        }
        return super.m_6375_(x, y, p_94697_);
    }
}

