/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.Client.screens;

import com.ricardthegreat.holdmetight.size.PlayerSize;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SizePrefsScreen
extends Screen {
    private static final Component TITLE = Component.m_237113_((String)"Size Prefs Screen");
    protected static final Component MAX_BUTTON = Component.m_237113_((String)"set max");
    protected static final Component MIN_BUTTON = Component.m_237113_((String)"set min");
    protected static final Component DEFAULT_BUTTON = Component.m_237113_((String)"set default");
    protected static final Component MAX_BUTTON_TOOLTIP = Component.m_237113_((String)"set your maximum scale");
    protected static final Component MIN_BUTTON_TOOLTIP = Component.m_237113_((String)"set minimum scale");
    protected static final Component DEFAULT_BUTTON_TOOLTIP = Component.m_237113_((String)"set default scale");
    protected static final Component MAX_SCALE_FIELD = Component.m_237113_((String)"max scale");
    protected static final Component MIN_SCALE_FIELD = Component.m_237113_((String)"min scale");
    protected static final Component DEFAULT_SCALE_FIELD = Component.m_237113_((String)"default scale");
    protected static final Component MAX_SCALE_FIELD_TOOLTIP = Component.m_237113_((String)"input max scale");
    protected static final Component MIN_SCALE_FIELD_TOOLTIP = Component.m_237113_((String)"input min scale");
    protected static final Component DEFAULT_SCALE_FIELD_TOOLTIP = Component.m_237113_((String)"input default scale");
    private final int imageWidth;
    private final int imageHeight;
    private ResourceLocation BACKGROUND = new ResourceLocation("holdmetight", "textures/gui/size_remote_bg.png");
    private Player player;
    private PlayerSize playerSize;
    private int leftPos;
    private int rightPos;
    private int topPos;
    private int bottomPos;
    private int centerHorizonalPos;
    private int centerVerticalPos;
    protected Button maxButton;
    protected Button minButton;
    protected Button defaultButton;
    protected EditBox maxScaleField;
    protected EditBox minScaleField;
    protected EditBox defaultScaleField;

    public SizePrefsScreen(Player player) {
        super(TITLE);
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.player = player;
        this.playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.rightPos = this.f_96543_ - this.leftPos;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.bottomPos = this.f_96544_ - this.topPos;
        this.centerHorizonalPos = (this.leftPos + this.rightPos) / 2;
        this.centerVerticalPos = (this.topPos + this.bottomPos) / 2;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        this.initButtons();
        this.initEditBoxes();
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280509_(this.leftPos, this.topPos, this.rightPos, this.bottomPos, -16777216);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280056_(this.f_96547_, String.valueOf(this.playerSize.getCurrentScale()), this.leftPos + 8 + this.f_96547_.m_92895_("Current scale: "), this.topPos + 18, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, String.valueOf(this.playerSize.getMaxScale()), this.leftPos + 8 + this.f_96547_.m_92895_("Max scale: "), this.topPos + 30, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, String.valueOf(this.playerSize.getMinScale()), this.leftPos + 8 + this.f_96547_.m_92895_("Min scale: "), this.topPos + 40, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, String.valueOf(this.playerSize.getDefaultScale()), this.leftPos + 8 + this.f_96547_.m_92895_("Default scale: "), this.topPos + 50, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, "Current scale:", this.leftPos + 8, this.topPos + 18, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, "Max scale:", this.leftPos + 8, this.topPos + 30, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, "Min scale:", this.leftPos + 8, this.topPos + 40, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, "Default scale:", this.leftPos + 8, this.topPos + 50, 0xDDDDDD, false);
    }

    private void saveEditBox() {
    }

    protected void initButtons() {
        this.maxButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)MAX_BUTTON, this::handleMaxButton).m_252987_(this.leftPos + 8, this.bottomPos - 111, 74, 20).m_257505_(Tooltip.m_257550_((Component)MAX_BUTTON_TOOLTIP)).m_253136_());
        this.minButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)MIN_BUTTON, this::handleMinButton).m_252987_(this.leftPos + 91, this.bottomPos - 111, 74, 20).m_257505_(Tooltip.m_257550_((Component)MIN_BUTTON_TOOLTIP)).m_253136_());
        this.defaultButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)DEFAULT_BUTTON, this::handleDefaultButton).m_252987_(this.leftPos + 174, this.bottomPos - 111, 74, 20).m_257505_(Tooltip.m_257550_((Component)DEFAULT_BUTTON_TOOLTIP)).m_253136_());
    }

    protected void handleMaxButton(Button button) {
        String scaleString = this.maxScaleField.m_94155_();
        if (scaleString != null && !scaleString.isEmpty()) {
            this.playerSize.setMaxScale(Float.valueOf(Float.parseFloat(scaleString)));
            this.playerSize.updateShouldSync();
        }
    }

    protected void handleMinButton(Button button) {
        String scaleString = this.minScaleField.m_94155_();
        if (scaleString != null && !scaleString.isEmpty()) {
            this.playerSize.setMinScale(Float.valueOf(Float.parseFloat(scaleString)));
            this.playerSize.updateShouldSync();
        }
    }

    protected void handleDefaultButton(Button button) {
        String scaleString = this.defaultScaleField.m_94155_();
        if (scaleString != null && !scaleString.isEmpty()) {
            this.playerSize.setDefaultScale(Float.valueOf(Float.parseFloat(scaleString)));
            this.playerSize.updateShouldSync();
        }
    }

    protected void initEditBoxes() {
        this.maxScaleField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 8, this.bottomPos - 80, 74, 20, MAX_SCALE_FIELD));
        this.minScaleField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 91, this.bottomPos - 80, 74, 20, MIN_SCALE_FIELD));
        this.defaultScaleField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 174, this.bottomPos - 80, 74, 20, DEFAULT_SCALE_FIELD));
        Predicate<String> filter = new Predicate<String>(){

            @Override
            public boolean test(String t) {
                if (!t.trim().equals(t)) {
                    return false;
                }
                if (t != null && t.isEmpty()) {
                    return true;
                }
                String checkFinalChar = t.substring(t.length() - 1);
                if (checkFinalChar.equals("f") || checkFinalChar.equals("d")) {
                    return false;
                }
                try {
                    float f = Float.parseFloat(t);
                    return !(f < 0.0f);
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.maxScaleField.m_94153_((Predicate)filter);
        this.minScaleField.m_94153_((Predicate)filter);
        this.defaultScaleField.m_94153_((Predicate)filter);
        this.maxScaleField.m_94144_(Float.toString(this.playerSize.getMaxScale()));
        this.minScaleField.m_94144_(Float.toString(this.playerSize.getMinScale()));
        this.defaultScaleField.m_94144_(Float.toString(this.playerSize.getDefaultScale()));
        this.maxScaleField.m_257544_(Tooltip.m_257563_((Component)MAX_SCALE_FIELD_TOOLTIP, (Component)MAX_SCALE_FIELD_TOOLTIP));
        this.minScaleField.m_257544_(Tooltip.m_257563_((Component)MIN_SCALE_FIELD_TOOLTIP, (Component)MIN_SCALE_FIELD_TOOLTIP));
        this.defaultScaleField.m_257544_(Tooltip.m_257563_((Component)DEFAULT_SCALE_FIELD_TOOLTIP, (Component)DEFAULT_SCALE_FIELD_TOOLTIP));
    }

    public void m_7379_() {
        this.saveEditBox();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

