/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.blockentities;

import com.ricardthegreat.holdmetight.init.BlockEntityInit;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MushroomTeleporterBlockEntity
extends BlockEntity {
    private int houseNum = -1;
    private boolean structureGenerated = false;
    private Vec3i housePos = null;

    public MushroomTeleporterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.MUSHROOM_HOUSE_ENTITY.get(), pos, state);
    }

    public int getHouseNum() {
        return this.houseNum;
    }

    public void setHouseNum(int houseNum) {
        this.houseNum = houseNum;
    }

    public boolean hasHouseNum() {
        return this.houseNum != -1;
    }

    public boolean getStructureGenerated() {
        return this.structureGenerated;
    }

    public void setStructureGenerated(boolean structureGenerated) {
        this.structureGenerated = structureGenerated;
    }

    public Vec3i getHousePos() {
        if (this.housePos == null) {
            this.housePos = this.genSpiralHousePos();
        }
        return this.housePos;
    }

    public void setHousePos(Vec3i housePos) {
        this.housePos = housePos;
    }

    private Vec3i genSpiralHousePos() {
        LinkedList<Integer> dir = new LinkedList<Integer>();
        dir.add(0);
        dir.add(1);
        dir.add(2);
        dir.add(3);
        int dist = 1;
        int distIncrease = 1;
        int[] pos = new int[]{0, 0};
        for (int i = 0; i < this.houseNum; ++i) {
            switch ((Integer)dir.peek()) {
                case 0: {
                    pos[0] = pos[0] + 1;
                    --dist;
                    break;
                }
                case 1: {
                    pos[1] = pos[1] - 1;
                    --dist;
                    break;
                }
                case 2: {
                    pos[0] = pos[0] - 1;
                    --dist;
                    break;
                }
                case 3: {
                    pos[1] = pos[1] + 1;
                    --dist;
                    break;
                }
            }
            if (dist != 0) continue;
            if ((Integer)dir.peek() == 1 || (Integer)dir.peek() == 3) {
                dist = 1 + distIncrease;
                ++distIncrease;
            } else {
                dist = distIncrease;
            }
            dir.add((Integer)dir.poll());
        }
        return new Vec3i(pos[0] * 25, 64, pos[1] * 25);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag mushroomTeleporterData = nbt.m_128469_("holdmetight");
        this.houseNum = mushroomTeleporterData.m_128451_("houseNum");
        this.structureGenerated = mushroomTeleporterData.m_128471_("structureGenerated");
        if (this.structureGenerated) {
            this.housePos = new Vec3i(mushroomTeleporterData.m_128451_("xpos"), mushroomTeleporterData.m_128451_("ypos"), mushroomTeleporterData.m_128451_("zpos"));
        }
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag mushroomTeleporterData = new CompoundTag();
        mushroomTeleporterData.m_128405_("houseNum", this.houseNum);
        mushroomTeleporterData.m_128379_("structureGenerated", this.structureGenerated);
        if (this.housePos != null) {
            mushroomTeleporterData.m_128405_("xpos", this.housePos.m_123341_());
            mushroomTeleporterData.m_128405_("ypos", this.housePos.m_123342_());
            mushroomTeleporterData.m_128405_("zpos", this.housePos.m_123343_());
        }
        nbt.m_128365_("holdmetight", (Tag)mushroomTeleporterData);
    }
}

