/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.carry;

import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerCarryProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerCarry> PLAYER_CARRY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerCarry>(){});
    private PlayerCarry size = null;
    private final LazyOptional<PlayerCarry> optional = LazyOptional.of(this::createPlayerCarry);

    private PlayerCarry createPlayerCarry() {
        if (this.size == null) {
            this.size = new PlayerCarry();
        }
        return this.size;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createPlayerCarry().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createPlayerCarry().loadNBTData(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == PLAYER_CARRY) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public static PlayerCarry getPlayerCarryCapability(Player player) {
        LazyOptional optional = player.getCapability(PLAYER_CARRY);
        return (PlayerCarry)optional.orElse((Object)new PlayerCarry());
    }
}

