/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.items;

import com.ricardthegreat.holdmetight.Config;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class PaperWingsItemBackup
extends Item
implements Equipable {
    public PaperWingsItemBackup(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_269277_(@Nonnull Item item, @Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        if ((double)EntitySizeUtils.getSize((Entity)player) > 0.5) {
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
        }
        return this.m_269277_(item, level, player, hand);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        if (!this.checkCorrectScale((Entity)entity)) {
            return false;
        }
        return ElytraItem.m_41140_((ItemStack)stack);
    }

    private boolean checkCorrectScale(Entity ent) {
        return !((double)EntitySizeUtils.getSize(ent) >= Config.maxWingsScale);
    }

    public static boolean isFlyEnabled(ItemStack p_41141_) {
        return p_41141_.m_41773_() < p_41141_.m_41776_() - 1;
    }

    public boolean m_6832_(ItemStack p_41134_, ItemStack p_41135_) {
        return p_41135_.m_150930_(Items.f_42714_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41137_, Player p_41138_, InteractionHand p_41139_) {
        return this.m_269277_(this, p_41137_, p_41138_, p_41139_);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        if (!entity.m_9236_().f_46443_ && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            if (nextFlightTick % 20 == 0) {
                stack.m_41622_(1, entity, e -> e.m_21166_(EquipmentSlot.CHEST));
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    public SoundEvent m_150681_() {
        return SoundEvents.f_11674_;
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.CHEST;
    }
}

