/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.customchatsizes;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.ricardthegreat.holdmetight.Config;
import com.ricardthegreat.holdmetight.utils.IChatComponentPlayerSent;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public abstract class ServerPlayerMixin
implements IChatComponentPlayerSent {
    private final List<GameProfile> profiles = Lists.newArrayList();
    private final List<Float> scales = Lists.newArrayList();
    private final List<Component> nonFormattedMessages = Lists.newArrayList();
    private final List<GuiMessage.Line> formattedMessagesNoName = Lists.newArrayList();
    private final List<Component> names = Lists.newArrayList();
    @Shadow
    List<GuiMessage.Line> f_93761_;
    @Shadow
    Minecraft f_93758_;
    @Shadow
    int f_93763_;
    @Shadow
    boolean f_93764_;

    @Shadow
    abstract boolean m_93817_();

    @Shadow
    abstract boolean m_93818_();

    @Shadow
    abstract int m_246107_(double var1, double var3);

    @Shadow
    abstract double m_240491_(double var1);

    @Shadow
    abstract double m_240485_(double var1);

    @Shadow
    abstract int m_240691_();

    @Shadow
    private static double m_93775_(int p_93776_) {
        return 0.0;
    }

    @Shadow
    abstract int m_240495_(GuiMessage.Line var1);

    @Shadow
    abstract void m_280134_(GuiGraphics var1, int var2, int var3, GuiMessageTag.Icon var4);

    @Inject(at={@At(value="HEAD")}, method={"render(Lnet/minecraft/client/gui/GuiGraphics;III)V"}, cancellable=true)
    public void render(GuiGraphics graphics, int p_283491_, int p_282406_, int p_283111_, CallbackInfo info) {
        if (Config.playerChatScale) {
            this.customRender(graphics, p_283491_, p_282406_, p_283111_);
            info.cancel();
        }
    }

    private void customRender(GuiGraphics graphics, int p_283491_, int p_282406_, int p_283111_) {
        if (!this.m_93817_()) {
            int i = ((ChatComponent)this).m_93816_();
            int j = this.f_93761_.size();
            if (j > 0) {
                boolean flag = this.m_93818_();
                float f = (float)((ChatComponent)this).m_93815_();
                int k = Mth.m_14167_((float)((float)((ChatComponent)this).m_93813_() / f));
                int l = graphics.m_280206_();
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(f, f, 1.0f);
                graphics.m_280168_().m_252880_(4.0f, 0.0f, 0.0f);
                int i1 = Mth.m_14143_((float)((float)(l - 40) / f));
                int j1 = this.m_246107_(this.m_240491_(p_282406_), this.m_240485_(p_283111_));
                double d0 = (Double)this.f_93758_.f_91066_.m_232098_().m_231551_() * (double)0.9f + (double)0.1f;
                double d1 = (Double)this.f_93758_.f_91066_.m_232104_().m_231551_();
                double d2 = (Double)this.f_93758_.f_91066_.m_232101_().m_231551_();
                int k1 = this.m_240691_();
                int l1 = (int)Math.round(-8.0 * (d2 + 1.0) + 4.0 * d2);
                int i2 = 0;
                for (int j2 = 0; j2 + this.f_93763_ < this.f_93761_.size() && j2 < i; ++j2) {
                    int l2;
                    int k2 = j2 + this.f_93763_;
                    GuiMessage.Line guimessage$line = this.f_93761_.get(k2);
                    if (guimessage$line == null || (l2 = p_283491_ - guimessage$line.f_240350_()) >= 200 && !flag) continue;
                    double d3 = flag ? 1.0 : ServerPlayerMixin.m_93775_(l2);
                    int j3 = (int)(255.0 * d3 * d0);
                    int k3 = (int)(255.0 * d3 * d1);
                    ++i2;
                    if (j3 <= 3) continue;
                    boolean l3 = false;
                    int i4 = i1 - j2 * k1;
                    int j4 = i4 + l1;
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
                    graphics.m_280509_(-4, i4 - k1, 0 + k + 4 + 4, i4, k3 << 24);
                    GuiMessageTag guimessagetag = guimessage$line.f_240351_();
                    if (guimessagetag != null) {
                        int k4 = guimessagetag.f_240386_() | j3 << 24;
                        graphics.m_280509_(-4, i4 - k1, -2, i4, k4);
                        if (k2 == j1 && guimessagetag.f_240355_() != null) {
                            int l4 = this.m_240495_(guimessage$line);
                            int i5 = j4 + 9;
                            this.m_280134_(graphics, l4, i5, guimessagetag.f_240355_());
                        }
                    }
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
                    if (this.scales.get(k2).floatValue() < 1.0f) {
                        this.calcChatSize(graphics, k2, j4, j3);
                    } else {
                        graphics.m_280648_(this.f_93758_.f_91062_, guimessage$line.f_240339_(), 0, j4, 0xFFFFFF + (j3 << 24));
                    }
                    graphics.m_280168_().m_85849_();
                }
                long j5 = this.f_93758_.m_240442_().m_242024_();
                if (j5 > 0L) {
                    int k5 = (int)(128.0 * d0);
                    int i6 = (int)(255.0 * d1);
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, (float)i1, 50.0f);
                    graphics.m_280509_(-2, 0, k + 4, 9, i6 << 24);
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, 50.0f);
                    graphics.m_280430_(this.f_93758_.f_91062_, (Component)Component.m_237110_((String)"chat.queue", (Object[])new Object[]{j5}), 0, 1, 0xFFFFFF + (k5 << 24));
                    graphics.m_280168_().m_85849_();
                }
                if (flag) {
                    int l5 = this.m_240691_();
                    int j6 = j * l5;
                    int k6 = i2 * l5;
                    int i3 = this.f_93763_ * k6 / j - i1;
                    int l6 = k6 * k6 / j6;
                    if (j6 != k6) {
                        int i7 = i3 > 0 ? 170 : 96;
                        int j7 = this.f_93764_ ? 0xCC3333 : 0x3333AA;
                        int k7 = k + 4;
                        graphics.m_280509_(k7, -i3, k7 + 2, -i3 - l6, j7 + (i7 << 24));
                        graphics.m_280509_(k7 + 2, -i3, k7 + 1, -i3 - l6, 0xCCCCCC + (i7 << 24));
                    }
                }
                graphics.m_280168_().m_85849_();
            }
        }
    }

    @Override
    public void addMessage(Component component, @Nullable MessageSignature signature, @Nullable GuiMessageTag tag, GameProfile profile) {
        ClientLevel level = this.f_93758_.f_91073_;
        Player player = null;
        float scale = 1.0f;
        if (level != null) {
            player = level.m_46003_(profile.getId());
        }
        if (player != null) {
            scale = EntitySizeUtils.getSize(player) > 1.0f ? 1.0f : EntitySizeUtils.getSize((Entity)player);
        }
        Component[] comps = this.takeNameFromComponent(component);
        List<FormattedCharSequence> nameList = this.getCompCharSequence(component, tag);
        int nameSize = nameList.size();
        List<FormattedCharSequence> noNameList = this.getCompCharSequence(comps[1], tag);
        int noNameSize = noNameList.size();
        List<FormattedCharSequence> name = this.getCompCharSequence(comps[0], tag);
        for (int j = 0; j < nameSize; ++j) {
            FormattedCharSequence formattedcharsequence = noNameList.get(j);
            boolean flag1 = j == noNameList.size() - 1;
            this.formattedMessagesNoName.add(0, new GuiMessage.Line(this.f_93758_.f_91065_.m_93079_(), formattedcharsequence, tag, flag1));
            this.profiles.add(0, profile);
            this.scales.add(0, Float.valueOf(scale));
            if (j == 0) {
                this.names.add(0, comps[0]);
                continue;
            }
            this.names.add(0, (Component)Component.m_237119_());
        }
        this.clearExcess();
        ((ChatComponent)this).m_240964_(component, signature, tag);
    }

    private void clearExcess() {
        while (this.profiles.size() > 100) {
            this.profiles.remove(this.profiles.size() - 1);
        }
        while (this.scales.size() > 100) {
            this.scales.remove(this.scales.size() - 1);
        }
        while (this.nonFormattedMessages.size() > 100) {
            this.nonFormattedMessages.remove(this.nonFormattedMessages.size() - 1);
        }
    }

    private void calcChatSize(GuiGraphics graphics, int pos, int j4, int j3) {
        graphics.m_280168_().m_85836_();
        if (this.names.get(pos) != Component.m_237119_()) {
            GuiMessage.Line name = new GuiMessage.Line(this.f_93758_.f_91065_.m_93079_(), this.getCompCharSequence(this.names.get(pos), null).get(0), null, true);
            graphics.m_280648_(this.f_93758_.f_91062_, name.f_240339_(), 0, j4, 0xFFFFFF + (j3 << 24));
            graphics.m_280168_().m_252880_((float)(this.f_93758_.f_91062_.m_92724_(name.f_240339_()) + 3), 0.0f, 0.0f);
        }
        float scale = this.scales.get(pos).floatValue();
        float logScale = (float)(Math.log(scale) / Math.log(0.1));
        logScale += 1.0f;
        logScale = 1.0f / logScale;
        FormattedCharSequence message = this.formattedMessagesNoName.get(pos).f_240339_();
        if ((double)logScale < 0.25 && this.names.get(pos) != Component.m_237119_()) {
            logScale = 0.5f;
            String s = "*indecernable*";
            message = this.getCompCharSequence((Component)Component.m_237113_((String)s), null).get(0);
        } else if ((double)logScale < 0.25) {
            logScale = 0.0f;
        }
        graphics.m_280168_().m_252880_(0.0f, (float)(295 - 9 * pos) * (1.0f - logScale) / (float)((ChatComponent)this).m_93815_(), 0.0f);
        graphics.m_280168_().m_85841_(logScale, logScale, 1.0f);
        graphics.m_280648_(this.f_93758_.f_91062_, message, 0, j4, 0xFFFFFF + (j3 << 24));
        graphics.m_280168_().m_85849_();
    }

    private Component[] takeNameFromComponent(Component component) {
        String message = component.getString();
        String[] messageParts = message.split(">");
        for (int i = 0; i < messageParts.length - 1; ++i) {
            messageParts[i] = messageParts[i] + ">";
        }
        String messageName = messageParts[0];
        Object messageBody = "";
        for (int i = 1; i < messageParts.length; ++i) {
            messageBody = (String)messageBody + messageParts[i];
        }
        Component[] comps = new Component[]{Component.m_237113_((String)messageName), Component.m_237113_((String)messageBody)};
        return comps;
    }

    private List<FormattedCharSequence> getCompCharSequence(Component component, @Nullable GuiMessageTag tag) {
        int i = Mth.m_14107_((double)((double)((ChatComponent)this).m_93813_() / ((ChatComponent)this).m_93815_()));
        if (tag != null && tag.f_240355_() != null) {
            i -= tag.f_240355_().f_240358_ + 4 + 2;
        }
        List list = ComponentRenderUtils.m_94005_((FormattedText)component, (int)i, (Font)this.f_93758_.f_91062_);
        return list;
    }
}

