/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.network;

import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.size.PlayerSize;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class SPlayerSizeMixinSyncPacket {
    private final float maxScale;
    private final float minScale;
    private final float defaultScale;
    private final float currentScale;
    private final float targetScale;
    private final int remainingTicks;
    private final UUID uuid;

    public SPlayerSizeMixinSyncPacket(float maxScale, float minScale, float defaultScale, float currentScale, float targetScale, int remainingTicks, UUID uuid) {
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.defaultScale = defaultScale;
        this.currentScale = currentScale;
        this.targetScale = targetScale;
        this.remainingTicks = remainingTicks;
        this.uuid = uuid;
    }

    public SPlayerSizeMixinSyncPacket(FriendlyByteBuf buffer) {
        this(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt(), buffer.m_130259_());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.maxScale);
        buffer.writeFloat(this.minScale);
        buffer.writeFloat(this.defaultScale);
        buffer.writeFloat(this.currentScale);
        buffer.writeFloat(this.targetScale);
        buffer.writeInt(this.remainingTicks);
        buffer.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        LazyOptional optional;
        ServerPlayer player = context.get().getSender();
        ServerPlayer target = player.f_8924_.m_6846_().m_11259_(this.uuid);
        if (target != null && (optional = player.getCapability(PlayerSizeProvider.PLAYER_SIZE)).isPresent()) {
            PlayerSize orElse = (PlayerSize)optional.orElse((Object)new PlayerSize());
            orElse.updateSyncables(this.maxScale, this.minScale, this.defaultScale, this.currentScale, this.targetScale, this.remainingTicks);
            PacketHandler.sendToAllClients(orElse.getSyncPacket((Player)player));
        }
    }
}

