/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.size;

import com.ricardthegreat.holdmetight.Config;
import com.ricardthegreat.holdmetight.network.CPlayerSizeMixinSyncPacket;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.network.SPlayerSizeMixinSyncPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class PlayerSize {
    private float maxScale = 50000.0f;
    private float minScale = 0.0f;
    private float defaultScale = 1.0f;
    private float currentScale = 1.0f;
    private float targetScale = 1.0f;
    private boolean perpetualChange = false;
    private float perpetualChangeValue = 1.0f;
    private int remainingTicks = 0;
    private float maxHitboxScale = (float)Config.maxHitboxScale;
    boolean shouldSync = false;

    public void tick(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData baseData = pEnt.pehkui_getScaleData(ScaleTypes.BASE);
        if (baseData.getScale() != this.currentScale) {
            this.targetScale = this.currentScale = baseData.getScale();
            this.setPeripheralScales(player);
            this.shouldSync = true;
        }
        if (!player.m_9236_().f_46443_) {
            if (this.remainingTicks > 0) {
                this.nextScaleStep();
                int tempScaleDelay = baseData.getScaleTickDelay();
                if (tempScaleDelay != 1) {
                    baseData.setScaleTickDelay(1);
                }
                baseData.setTargetScale(this.currentScale);
                this.setPeripheralScales(player);
                this.shouldSync = true;
                baseData.setScaleTickDelay(tempScaleDelay);
            }
            if (this.perpetualChange) {
                baseData.setScale(this.currentScale * this.perpetualChangeValue);
                this.setPeripheralScales(player);
                this.shouldSync = true;
            }
        }
        if (this.shouldSync) {
            this.sync(player);
        }
    }

    private void sync(Player player) {
        this.shouldSync = false;
        if (player.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.sendToServer(new SPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, this.currentScale, this.targetScale, this.remainingTicks, player.m_20148_())));
        } else if (!player.m_20194_().m_6982_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.sendToAllClients(new CPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, this.currentScale, this.targetScale, this.remainingTicks, player.m_20148_())));
        } else {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> PacketHandler.sendToAllClients(new CPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, this.currentScale, this.targetScale, this.remainingTicks, player.m_20148_())));
        }
    }

    public void updateSyncables(float maxScale, float minScale, float defaultScale, float currentScale, float targetScale, int remainingTicks) {
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.defaultScale = defaultScale;
        this.currentScale = currentScale;
        this.targetScale = targetScale;
        this.remainingTicks = remainingTicks;
    }

    public CPlayerSizeMixinSyncPacket getSyncPacket(Player player) {
        return new CPlayerSizeMixinSyncPacket(this.maxScale, this.minScale, this.defaultScale, this.currentScale, this.targetScale, this.remainingTicks, player.m_20148_());
    }

    private void nextScaleStep() {
        this.clampToPreferences();
        float scaleChange = (this.targetScale - this.currentScale) / (float)this.remainingTicks;
        this.currentScale += scaleChange;
        --this.remainingTicks;
    }

    private void setPeripheralScales(Player player) {
        this.clampMaxHitbox(player);
        this.fixStepHeight(player);
        this.setFallDamage(player);
        if (Config.miningSpeedScaleLink) {
            this.setMiningSpeed(player);
        }
        if (Config.damageTakenScaleLink) {
            this.setDefence(player);
        }
    }

    private void clampMaxHitbox(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData heightData = pEnt.pehkui_getScaleData(ScaleTypes.HITBOX_HEIGHT);
        ScaleData widthData = pEnt.pehkui_getScaleData(ScaleTypes.HITBOX_WIDTH);
        if (this.currentScale > this.maxHitboxScale) {
            heightData.setScale(this.maxHitboxScale / this.currentScale);
            widthData.setScale(this.maxHitboxScale / this.currentScale);
        } else if (heightData.getTargetScale() < 1.0f || widthData.getTargetScale() < 1.0f) {
            heightData.setScale(1.0f);
            widthData.setScale(1.0f);
        }
    }

    private void setFallDamage(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData fallData = pEnt.pehkui_getScaleData(ScaleTypes.FALLING);
        if (this.currentScale < 1.0f) {
            fallData.setScale(this.currentScale);
        } else if (fallData.getScale() < 1.0f) {
            fallData.setScale(1.0f);
        }
    }

    private void setDefence(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData defenceData = pEnt.pehkui_getScaleData(ScaleTypes.DEFENSE);
        defenceData.setScale((float)Math.sqrt(this.currentScale));
    }

    private void setMiningSpeed(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData miningData = pEnt.pehkui_getScaleData(ScaleTypes.MINING_SPEED);
        miningData.setScale(this.currentScale);
    }

    private void fixStepHeight(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData stepData = pEnt.pehkui_getScaleData(ScaleTypes.STEP_HEIGHT);
        float stepHeight = (float)(1.0 / Math.sqrt(this.currentScale));
        stepData.setScale(stepHeight);
    }

    private void clampToPreferences() {
        if (this.targetScale < this.minScale) {
            this.targetScale = this.minScale;
        }
        if (this.targetScale > this.maxScale) {
            this.targetScale = this.maxScale;
        }
    }

    public float getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Float maxScale) {
        if (maxScale.floatValue() < this.minScale) {
            maxScale = Float.valueOf(this.minScale);
        }
        if (maxScale.floatValue() < this.defaultScale) {
            this.defaultScale = maxScale.floatValue();
        }
        this.maxScale = maxScale.floatValue();
    }

    public float getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Float minScale) {
        if (minScale.floatValue() > this.maxScale) {
            minScale = Float.valueOf(this.maxScale);
        }
        if (minScale.floatValue() > this.defaultScale) {
            this.defaultScale = minScale.floatValue();
        }
        this.minScale = minScale.floatValue();
    }

    public float getDefaultScale() {
        return this.defaultScale;
    }

    public void setDefaultScale(Float defaultScale) {
        this.defaultScale = defaultScale.floatValue() > this.maxScale ? this.maxScale : (defaultScale.floatValue() < this.minScale ? this.minScale : defaultScale.floatValue());
    }

    public Float getTargetScale() {
        return Float.valueOf(this.targetScale);
    }

    public void setTargetScale(Float targetScale) {
        this.targetScale = targetScale.floatValue() > this.maxScale ? this.maxScale : (targetScale.floatValue() < this.minScale ? this.minScale : targetScale.floatValue());
    }

    public Float getCurrentScale() {
        return Float.valueOf(this.currentScale);
    }

    public void setCurrentScale(Float currentScale) {
        this.currentScale = currentScale.floatValue();
    }

    public int getRemainingTicks() {
        return this.remainingTicks;
    }

    public void setRemainingTicks(int remainingTicks) {
        this.remainingTicks = remainingTicks;
    }

    public boolean getPerpetualChange() {
        return this.perpetualChange;
    }

    public void setPerpetualChange(boolean perpetualChange) {
        this.perpetualChange = perpetualChange;
    }

    public float getPerpetualChangeValue() {
        return this.perpetualChangeValue;
    }

    public void setPerpetualChangeValue(float perpetualChangeValue) {
        this.perpetualChangeValue = perpetualChangeValue;
    }

    public void updateShouldSync() {
        this.shouldSync = true;
    }

    public void copyAll(PlayerSize source) {
        this.maxScale = source.maxScale;
        this.minScale = source.minScale;
        this.defaultScale = source.defaultScale;
        this.currentScale = source.currentScale;
        this.targetScale = source.targetScale;
        this.perpetualChange = source.perpetualChange;
        this.perpetualChangeValue = source.perpetualChangeValue;
        this.remainingTicks = source.remainingTicks;
    }

    public void copyBasic(PlayerSize source) {
        this.maxScale = source.maxScale;
        this.minScale = source.minScale;
        this.defaultScale = source.defaultScale;
    }

    public void saveNBTData(CompoundTag tag) {
        tag.m_128350_("maxScale", this.maxScale);
        tag.m_128350_("minScale", this.minScale);
        tag.m_128350_("defaultScale", this.defaultScale);
        tag.m_128350_("currentScale", this.currentScale);
        tag.m_128350_("targetScale", this.targetScale);
        tag.m_128379_("perpetualChange", this.perpetualChange);
        tag.m_128350_("perpetualChangeValue", this.perpetualChangeValue);
        tag.m_128405_("remainingTicks", this.remainingTicks);
    }

    public void loadNBTData(CompoundTag tag) {
        this.maxScale = tag.m_128457_("maxScale");
        this.minScale = tag.m_128457_("minScale");
        this.defaultScale = tag.m_128457_("defaultScale");
        this.currentScale = tag.m_128457_("currentScale");
        this.targetScale = tag.m_128457_("targetScale");
        this.perpetualChange = tag.m_128471_("perpetualChange");
        this.perpetualChangeValue = tag.m_128457_("perpetualChangeValue");
        this.remainingTicks = tag.m_128451_("remainingTicks");
    }

    private void ensureSizeSynced() {
    }
}

