/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.utils.sizeutils;

import com.ricardthegreat.holdmetight.size.PlayerSize;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import net.minecraft.world.entity.player.Player;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.PehkuiEntityExtensions;

public class PlayerSizeUtils {
    private static ScaleType base = ScaleTypes.BASE;

    public static void setSize(Player player, Float size, int ticks) {
        PlayerSize playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
        if (ticks >= 0) {
            if (ticks == 0) {
                float mult = size.floatValue() / playerSize.getCurrentScale().floatValue();
                playerSize.setCurrentScale(size);
                playerSize.setTargetScale(Float.valueOf(playerSize.getTargetScale().floatValue() * mult));
                if (playerSize.getRemainingTicks() == 0) {
                    playerSize.setRemainingTicks(1);
                }
            } else {
                playerSize.setTargetScale(size);
                playerSize.setRemainingTicks(ticks);
            }
        }
        playerSize.updateShouldSync();
    }

    public static void multSize(Player player, Float size, int ticks) {
        PlayerSize playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
        Float targetScale = Float.valueOf(playerSize.getTargetScale().floatValue() * size.floatValue());
        PlayerSizeUtils.setSize(player, targetScale, ticks);
    }

    public static void perpetualSize(Player player, Float size, int ticks) {
    }

    public static void addSize(Player player, Float size) {
        PlayerSize playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
        Float currentScale = playerSize.getCurrentScale();
        Float targetScale = playerSize.getTargetScale();
        playerSize.setCurrentScale(Float.valueOf(currentScale.floatValue() + size.floatValue()));
        playerSize.setTargetScale(Float.valueOf(targetScale.floatValue() + size.floatValue()));
        if (playerSize.getRemainingTicks() == 0) {
            playerSize.setRemainingTicks(1);
        }
        playerSize.updateShouldSync();
    }

    public static float getSize(Player player) {
        PlayerSize playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
        return playerSize.getCurrentScale().floatValue();
    }

    public static int getRemainingTicks(Player player) {
        PlayerSize playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
        return playerSize.getRemainingTicks();
    }

    public static float getTargetSize(Player player) {
        PlayerSize playerSize = PlayerSizeProvider.getPlayerSizeCapability(player);
        return playerSize.getTargetScale().floatValue();
    }

    private static ScaleData getScaleData(Player player) {
        PehkuiEntityExtensions pEnt = (PehkuiEntityExtensions)player;
        ScaleData data = pEnt.pehkui_getScaleData(base);
        return data;
    }
}

