/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.Client.screens;

import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.network.SSizeRaySync;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SizeRayScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"gui.holdmetight.size_ray");
    private static final Component SET_OR_MULT_BUTTON = Component.m_237115_((String)"gui.holdmetight.size_ray.button.set_or_mult_button");
    private static final Component CUSTOM_SCALE_FIELD = Component.m_237115_((String)"gui.holdmetight.size_ray.field.custom_scale_field");
    private static final Component CUSTOM_SCALE_FIELD_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_ray.field.custom_scale_field_tooltip");
    private static final Component SET_OR_MULT_BUTTON_TOOLTIP = Component.m_237115_((String)"gui.holdmetight.size_ray.button.set_or_mult_button_tooltip");
    private static final ResourceLocation TEXTURE = new ResourceLocation("holdmetight", "textures/gui/size_ray_bg.png");
    private final int imageWidth;
    private final int imageHeight;
    private Player user;
    private ItemStack stack;
    private CompoundTag tag;
    private int leftPos;
    private int rightPos;
    private int topPos;
    private int bottomPos;
    private int centerHorizonalPos;
    private int centerVerticalPos;
    private Button multButton;
    private Button setButton;
    private Button setOrMultButton;
    private EditBox customScaleField;

    public SizeRayScreen(Player user, InteractionHand hand) {
        super(TITLE);
        this.imageWidth = 256;
        this.imageHeight = 132;
        this.user = user;
        this.stack = user.m_21120_(hand);
        this.tag = this.stack.m_41783_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.rightPos = this.f_96543_ - this.leftPos;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.bottomPos = this.f_96544_ - this.topPos;
        this.centerHorizonalPos = (this.leftPos + this.rightPos) / 2;
        this.centerVerticalPos = (this.topPos + this.bottomPos) / 2;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        this.setOrMultButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)SET_OR_MULT_BUTTON, this::handleSetOrMultiplyButton).m_252987_(this.leftPos + 173, this.topPos + 64, 76, 20).m_257505_(Tooltip.m_257550_((Component)SET_OR_MULT_BUTTON_TOOLTIP)).m_253136_());
        this.initCustomScaleField();
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.tag.m_128471_("shouldMultiply")) {
            graphics.m_280056_(this.f_96547_, "Multiply scale by:", this.leftPos + 65, this.topPos + 18, 0xDDDDDD, false);
        } else {
            graphics.m_280056_(this.f_96547_, "Set scale to:", this.leftPos + 65, this.topPos + 18, 0xDDDDDD, false);
        }
        graphics.m_280056_(this.f_96547_, "" + this.tag.m_128457_("multiplier"), this.leftPos + 154, this.topPos + 18, 0xDDDDDD, false);
    }

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        String scaleString;
        if (key == 257 && (scaleString = this.customScaleField.m_94155_()) != null && !scaleString.isEmpty()) {
            Float scale = Float.valueOf(Float.parseFloat(scaleString));
            this.tag.m_128350_("multiplier", scale.floatValue());
            this.stack.m_41751_(this.tag);
        }
        return super.m_7933_(key, p_96553_, p_96554_);
    }

    private void initCustomScaleField() {
        this.customScaleField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.leftPos + 56, this.topPos + 64, 97, 20, CUSTOM_SCALE_FIELD));
        Predicate<String> filter = new Predicate<String>(){

            @Override
            public boolean test(String t) {
                if (!t.trim().equals(t)) {
                    return false;
                }
                if (t != null && t.isEmpty()) {
                    return true;
                }
                String checkFinalChar = t.substring(t.length() - 1);
                if (checkFinalChar.equals("f") || checkFinalChar.equals("d")) {
                    return false;
                }
                try {
                    Float.parseFloat(t);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.customScaleField.m_94153_((Predicate)filter);
        Float mul = Float.valueOf(this.tag.m_128457_("multiplier"));
        String floatString = Float.toString(mul.floatValue());
        this.customScaleField.m_94144_(floatString);
        Tooltip t = Tooltip.m_257563_((Component)CUSTOM_SCALE_FIELD_TOOLTIP, (Component)CUSTOM_SCALE_FIELD_TOOLTIP);
        this.customScaleField.m_257544_(t);
    }

    private void handleSetOrMultiplyButton(Button button) {
        String scaleString = this.customScaleField.m_94155_();
        if (scaleString != null && !scaleString.isEmpty()) {
            Float scale = Float.valueOf(Float.parseFloat(scaleString));
            this.tag.m_128379_("shouldMultiply", !this.tag.m_128471_("shouldMultiply"));
            this.tag.m_128350_("multiplier", scale.floatValue());
            this.stack.m_41751_(this.tag);
        }
    }

    public void m_7379_() {
        PacketHandler.sendToServer(new SSizeRaySync(this.tag));
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

