/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.Client.screens.remotes;

import com.ricardthegreat.holdmetight.utils.PlayerRenderExtension;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import com.ricardthegreat.holdmetight.utils.sizeutils.PlayerSizeUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractSizeRemoteScreen
extends Screen {
    protected static final float DEFAULT_SCALE = 1.0f;
    protected static final String TARGET = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.target_string").getString() + ":";
    protected static final String CURRENT_SCALE = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.current_scale_string").getString() + ":";
    protected static final String TARGET_SCALE = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.target_scale_string").getString() + ":";
    protected static final String SCALE_TIME = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.scale_time_string").getString() + ":";
    protected static final String NOT_APPLICABLE = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.not_applicable_string").getString();
    protected static final String OUT_OF_RANGE = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.out_of_range_string").getString();
    protected static final String NO_TARGET = Component.m_237115_((String)"gui.holdmetight.size_remote.strings.no_target_string").getString();
    protected final int imageWidth;
    protected final int imageHeight;
    protected Player user;
    protected Entity selectedEnt;
    protected ItemStack stack;
    protected CompoundTag tag;
    protected int range = 100;
    protected ResourceLocation BACKGROUND;
    protected int leftPos;
    protected int rightPos;
    protected int topPos;
    protected int bottomPos;
    protected int centerHorizonalPos;
    protected int centerVerticalPos;

    protected AbstractSizeRemoteScreen(Component title, Player user, InteractionHand hand, int width, int height) {
        super(title);
        this.imageWidth = width;
        this.imageHeight = height;
        this.user = user;
        this.stack = user.m_21120_(hand);
        this.tag = this.stack.m_41783_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.rightPos = this.f_96543_ - this.leftPos;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.bottomPos = this.f_96544_ - this.topPos;
        this.centerHorizonalPos = (this.leftPos + this.rightPos) / 2;
        this.centerVerticalPos = (this.topPos + this.bottomPos) / 2;
        if (this.f_96541_ == null) {
            return;
        }
        ClientLevel level = this.f_96541_.f_91073_;
        if (level == null) {
            return;
        }
        if (this.tag.m_128441_("has target") && !this.tag.m_128471_("has target")) {
            this.selectedEnt = null;
        } else if (this.tag.m_128471_("is player")) {
            this.selectedEnt = level.m_46003_(this.tag.m_128342_("target"));
            if (this.selectedEnt == null) {
                this.selectedEnt = this.user;
                this.tag.m_128362_("target", this.selectedEnt.m_20148_());
                this.stack.m_41751_(this.tag);
            }
        } else {
            this.selectedEnt = level.m_6815_(this.tag.m_128451_("entity id"));
        }
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(this.BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderPlayerDisplay(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderPlayerDisplay(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int screenLeft = this.leftPos + 8;
        int screenTop = this.topPos + 8;
        Objects.requireNonNull(this.f_96547_);
        int verTextSep = 9 + 5;
        graphics.m_280056_(this.f_96547_, TARGET, screenLeft + 2, screenTop + 2, 0xDDDDDD, false);
        graphics.m_280056_(this.f_96547_, CURRENT_SCALE, screenLeft + 2, screenTop + verTextSep, 0xDDDDDD, false);
        if (this.selectedEnt != null && this.selectedEnt instanceof Player) {
            Player selectedPlayer = (Player)this.selectedEnt;
            graphics.m_280056_(this.f_96547_, TARGET_SCALE, screenLeft + 2, screenTop + verTextSep * 2, 0xDDDDDD, false);
            graphics.m_280056_(this.f_96547_, SCALE_TIME, screenLeft + 2, screenTop + verTextSep * 3, 0xDDDDDD, false);
            if (this.inRange()) {
                graphics.m_280056_(this.f_96547_, selectedPlayer.m_7755_().getString(), screenLeft + this.f_96547_.m_92895_(TARGET) + 5, screenTop + 2, 11393254, false);
                graphics.m_280056_(this.f_96547_, Float.toString(PlayerSizeUtils.getSize(selectedPlayer)), screenLeft + this.f_96547_.m_92895_(CURRENT_SCALE) + 5, screenTop + verTextSep, 11393254, false);
                graphics.m_280056_(this.f_96547_, Float.toString(PlayerSizeUtils.getTargetSize(selectedPlayer)), screenLeft + this.f_96547_.m_92895_(TARGET_SCALE) + 5, screenTop + verTextSep * 2, 11393254, false);
                graphics.m_280056_(this.f_96547_, this.ticksToTime(PlayerSizeUtils.getRemainingTicks(selectedPlayer)), screenLeft + this.f_96547_.m_92895_(SCALE_TIME) + 5, screenTop + verTextSep * 3, 11393254, false);
            } else {
                graphics.m_280056_(this.f_96547_, OUT_OF_RANGE, screenLeft + this.f_96547_.m_92895_(TARGET) + 5, screenTop + 2, 0xFFFF00, false);
                graphics.m_280056_(this.f_96547_, NOT_APPLICABLE, screenLeft + this.f_96547_.m_92895_(CURRENT_SCALE) + 5, screenTop + verTextSep, 0xFFFF00, false);
            }
            PlayerRenderExtension rend = (PlayerRenderExtension)selectedPlayer;
            if (rend != null) {
                rend.setMenu(true);
                InventoryScreen.m_274545_((GuiGraphics)graphics, (int)this.centerHorizonalPos, (int)this.centerVerticalPos, (int)30, (float)((float)this.centerHorizonalPos - (float)mouseX), (float)((float)(this.centerVerticalPos - 80) - (float)mouseY), (LivingEntity)((Player)rend));
                rend.setMenu(false);
            }
        } else if (this.selectedEnt != null && this.selectedEnt instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)this.selectedEnt;
            if (this.inRange()) {
                graphics.m_280056_(this.f_96547_, ent.m_7755_().getString(), screenLeft + this.f_96547_.m_92895_(TARGET) + 5, screenTop + 2, 11393254, false);
                graphics.m_280056_(this.f_96547_, Float.toString(EntitySizeUtils.getSize((Entity)ent)), screenLeft + this.f_96547_.m_92895_(CURRENT_SCALE) + 5, screenTop + verTextSep, 11393254, false);
            } else {
                graphics.m_280056_(this.f_96547_, OUT_OF_RANGE, screenLeft + this.f_96547_.m_92895_(TARGET) + 5, screenTop + 2, 0xFFFF00, false);
                graphics.m_280056_(this.f_96547_, NOT_APPLICABLE, screenLeft + this.f_96547_.m_92895_(CURRENT_SCALE) + 5, screenTop + verTextSep, 0xFFFF00, false);
            }
            InventoryScreen.m_274545_((GuiGraphics)graphics, (int)this.centerHorizonalPos, (int)this.centerVerticalPos, (int)30, (float)((float)this.centerHorizonalPos - (float)mouseX), (float)((float)(this.centerVerticalPos - 80) - (float)mouseY), (LivingEntity)ent);
        } else {
            graphics.m_280056_(this.f_96547_, TARGET_SCALE, screenLeft + 2, screenTop + verTextSep * 2, 0xDDDDDD, false);
            graphics.m_280056_(this.f_96547_, SCALE_TIME, screenLeft + 2, screenTop + verTextSep * 3, 0xDDDDDD, false);
            graphics.m_280056_(this.f_96547_, NOT_APPLICABLE, screenLeft + this.f_96547_.m_92895_(TARGET) + 5, screenTop + 2, 0xFF0000, false);
            graphics.m_280056_(this.f_96547_, NO_TARGET, screenLeft + this.f_96547_.m_92895_(CURRENT_SCALE) + 5, screenTop + verTextSep, 0xFF0000, false);
            graphics.m_280056_(this.f_96547_, NOT_APPLICABLE, screenLeft + this.f_96547_.m_92895_(TARGET_SCALE) + 5, screenTop + verTextSep * 2, 0xFF0000, false);
            graphics.m_280056_(this.f_96547_, NOT_APPLICABLE, screenLeft + this.f_96547_.m_92895_(SCALE_TIME) + 5, screenTop + verTextSep * 3, 0xFF0000, false);
        }
    }

    protected String ticksToTime(int ticks) {
        int duration = (int)Math.ceil((double)ticks / 20.0);
        int seconds = 0;
        int minutes = 0;
        int hours = 0;
        seconds += duration % 60;
        minutes += (duration -= seconds) % 3600;
        duration -= minutes;
        hours = duration / 3600;
        Object output = "";
        output = hours < 10 ? (String)output + "0" + hours + ":" : (String)output + hours + ":";
        output = minutes < 10 ? (String)output + "0" + minutes + ":" : (String)output + (minutes /= 60) + ":";
        output = seconds < 10 ? (String)output + "0" + seconds : (String)output + seconds;
        return output;
    }

    protected boolean inRange() {
        double distance = this.user.m_20182_().m_82554_(this.selectedEnt.m_20182_());
        return distance <= (double)this.range;
    }

    protected abstract void saveEditBox();

    public void m_7379_() {
        this.saveEditBox();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

