/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.blocks;

import com.ricardthegreat.holdmetight.blockentities.MushroomTeleporterBlockEntity;
import com.ricardthegreat.holdmetight.init.BlockEntityInit;
import com.ricardthegreat.holdmetight.portal.ModTeleporter;
import com.ricardthegreat.holdmetight.save.MushroomHouseSavedData;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import com.ricardthegreat.holdmetight.worldgen.dimension.ModDimensions;
import com.ricardthegreat.holdmetight.worldgen.structures.MushroomHouseStructureGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.ITeleporter;

public class MushroomTeleporterBlock
extends Block
implements EntityBlock {
    public MushroomTeleporterBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ((BlockEntityType)BlockEntityInit.MUSHROOM_HOUSE_ENTITY.get()).m_155264_(pos, state);
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity bEntity = level.m_7702_(pos);
        if (!(bEntity instanceof MushroomTeleporterBlockEntity)) {
            System.out.println("nope");
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        MushroomTeleporterBlockEntity house = (MushroomTeleporterBlockEntity)bEntity;
        if (player.m_20194_() != null) {
            MushroomHouseSavedData m = MushroomHouseSavedData.getData(player.m_20194_());
            if (player.m_6144_()) {
                m.setTest(0);
            }
            if (!house.hasHouseNum()) {
                house.setHouseNum(m.getTest());
                m.setTest(m.getTest() + 1);
            }
        }
        if (player.m_6072_()) {
            this.handleTeleport((Entity)player, pos, house);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private void handleTeleport(Entity player, BlockPos pos, MushroomTeleporterBlockEntity house) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            MinecraftServer minecraftserver = serverlevel.m_7654_();
            ResourceKey<Level> resourcekey = player.m_9236_().m_46472_() == ModDimensions.DIM_LEVEL_KEY ? Level.f_46428_ : ModDimensions.DIM_LEVEL_KEY;
            ServerLevel portalDimension = minecraftserver.m_129880_(resourcekey);
            ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
            if (portalDimension != null && !player.m_20159_()) {
                if (resourcekey == ModDimensions.DIM_LEVEL_KEY) {
                    if (!house.getStructureGenerated()) {
                        house.setStructureGenerated(true);
                        MushroomHouseStructureGenerator.generateMushroomHouseStructure((LevelAccessor)portalDimension, house);
                    }
                    BlockPos targetPos = new BlockPos(house.getHousePos());
                    targetPos = targetPos.m_7494_();
                    EntitySizeUtils.setSize(player, Float.valueOf(1.0f), 0);
                    player.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(targetPos, true));
                } else {
                    System.out.println("dimteleporter:53");
                    player.changeDimension(overworld, (ITeleporter)new ModTeleporter(pos, false));
                }
            }
        }
    }
}

