/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.carry;

import com.ricardthegreat.holdmetight.carry.CarryPosition;
import com.ricardthegreat.holdmetight.network.CPlayerCarrySimplePacket;
import com.ricardthegreat.holdmetight.network.CPlayerCarrySyncPacket;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.network.SPlayerCarrySimplePacket;
import com.ricardthegreat.holdmetight.network.SPlayerCarrySyncPacket;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class PlayerCarry {
    private boolean isCarried = false;
    private final CarryPosition hand = new CarryPosition("hand", 110, 0.77, 0.65, 0.0, false);
    private final CarryPosition shoulder = new CarryPosition("shoulder", 90, 0.0, 0.38, -0.3, false);
    private CarryPosition custom = new CarryPosition("custom", 0, 0.0, 0.0, 0.0, false);
    private final ArrayList<CarryPosition> defaultCarryPositions = new ArrayList<CarryPosition>(Arrays.asList(this.hand, this.shoulder));
    private ArrayList<CarryPosition> customCarryPositions = new ArrayList<CarryPosition>(Arrays.asList(this.custom));
    private ArrayList<ArrayList<CarryPosition>> allCarryPositions = new ArrayList<ArrayList>(Arrays.asList(this.defaultCarryPositions, this.customCarryPositions));
    private boolean isCarrying = false;
    private int[] currentCarryPos = new int[]{0, 0};
    private boolean shouldSync = false;
    private boolean shouldSyncSimple = false;
    private boolean shouldSyncCustom = false;
    private boolean shouldSyncAll = false;

    public void tick(Player player) {
        if (this.shouldSync) {
            if (this.shouldSyncSimple) {
                this.shouldSyncSimple = false;
                this.syncSimple(player);
            } else if (this.shouldSyncCustom) {
                this.shouldSyncCustom = false;
                this.syncCustom(player);
            } else if (this.shouldSyncAll) {
                this.shouldSyncAll = false;
                this.sync(player);
            } else {
                this.shouldSync = false;
            }
        }
    }

    private void sync(Player player) {
        if (player.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.sendToServer(new SPlayerCarrySyncPacket(this.isCarried, this.isCarrying, this.currentCarryPos, this.customCarryPositions.get(0))));
        } else {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> PacketHandler.sendToAllClients(new CPlayerCarrySyncPacket(this.isCarried, this.isCarrying, this.currentCarryPos, this.customCarryPositions.get(0), player.m_20148_())));
        }
    }

    private void syncSimple(Player player) {
        if (player.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> PacketHandler.sendToServer(new SPlayerCarrySimplePacket(this.isCarried, this.isCarrying, this.currentCarryPos, player.m_20148_())));
        } else {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> PacketHandler.sendToAllClients(new CPlayerCarrySimplePacket(this.isCarried, this.isCarrying, this.currentCarryPos, player.m_20148_())));
        }
    }

    private void syncCustom(Player player) {
        if (player.m_9236_().f_46443_) {
            // empty if block
        }
    }

    public void updateAllSyncables(boolean isCarried, boolean isCarrying, int[] currentCarryPos, CarryPosition customCarry) {
        this.updateSimpleSyncables(isCarried, isCarrying, currentCarryPos);
        this.updatePositionSyncables(customCarry);
    }

    public void updateSimpleSyncables(boolean isCarried, boolean isCarrying, int[] currentCarryPos) {
        this.isCarried = isCarried;
        this.isCarrying = isCarrying;
        this.currentCarryPos = currentCarryPos;
    }

    public void updatePositionSyncables(CarryPosition customCarry) {
        this.custom = customCarry;
        int tempSize = this.customCarryPositions.size();
        for (int i = 0; i < tempSize; ++i) {
            this.customCarryPositions.set(i, this.custom);
        }
    }

    public boolean getIsCarried() {
        return this.isCarried;
    }

    public void setCarried(boolean isCarried) {
        this.isCarried = isCarried;
    }

    public boolean getIsCarrying() {
        return this.isCarrying;
    }

    public void setCarrying(boolean isCarrying) {
        this.isCarrying = isCarrying;
    }

    public void setCarryPosition(boolean custom, int pos) {
        if (custom) {
            if (pos < 0 || pos > this.customCarryPositions.size() - 1) {
                pos = 0;
            }
            this.currentCarryPos[0] = 1;
            this.currentCarryPos[1] = pos;
        } else {
            if (pos < 0 || pos > this.defaultCarryPositions.size() - 1) {
                pos = 0;
            }
            this.currentCarryPos[0] = 0;
            this.currentCarryPos[1] = pos;
        }
    }

    public CarryPosition getCarryPosition() {
        return this.allCarryPositions.get(this.currentCarryPos[0]).get(this.currentCarryPos[1]);
    }

    public ArrayList<ArrayList<CarryPosition>> getAllCarryPositions() {
        return this.allCarryPositions;
    }

    public void addCustomCarryPos(CarryPosition custom) {
        boolean added = false;
        this.customCarryPositions.set(0, custom);
    }

    public void removeCustomCarryPos(String name) {
        for (int i = 0; i < this.customCarryPositions.size(); ++i) {
            if (this.customCarryPositions.get((int)i).posName != this.custom.posName) continue;
            this.customCarryPositions.remove(i);
        }
    }

    public boolean getShouldSyncSimple() {
        return this.shouldSync;
    }

    public void setShouldSyncSimple(boolean shouldSyncSimple) {
        this.shouldSyncSimple = shouldSyncSimple;
        this.shouldSync = shouldSyncSimple;
    }

    public boolean getShouldSyncCustom() {
        return this.shouldSyncCustom;
    }

    public void setShouldSyncCustom(boolean shouldSyncCustom) {
        this.shouldSyncCustom = shouldSyncCustom;
        this.shouldSync = shouldSyncCustom;
    }

    public boolean getShouldSyncAll() {
        return this.shouldSyncAll;
    }

    public void setShouldSyncAll(boolean shouldSyncAll) {
        this.shouldSyncAll = shouldSyncAll;
        this.shouldSync = shouldSyncAll;
    }

    public void copyFrom(PlayerCarry source) {
        this.isCarried = source.isCarried;
        this.isCarrying = source.isCarrying;
        this.custom = source.custom;
        this.customCarryPositions = source.customCarryPositions;
        this.allCarryPositions = source.allCarryPositions;
    }

    public void saveNBTData(CompoundTag tag) {
        tag.m_128379_("isCarried", this.isCarried);
        tag.m_128379_("isCarrying", this.isCarrying);
        CarryPosition carry = this.customCarryPositions.get(0);
        tag.m_128359_("posName", carry.posName);
        tag.m_128405_("rotationOffset", carry.RotationOffset);
        tag.m_128347_("xymult", carry.xymult);
        tag.m_128347_("vertOffset", carry.vertOffset);
        tag.m_128347_("leftRightMove", carry.leftRightMove);
        tag.m_128379_("headLink", carry.headLink);
    }

    public void loadNBTData(CompoundTag tag) {
        this.isCarried = tag.m_128471_("isCarried");
        this.isCarrying = tag.m_128471_("isCarrying");
        this.custom = new CarryPosition(tag.m_128461_("posName"), tag.m_128451_("rotationOffset"), tag.m_128459_("xymult"), tag.m_128459_("vertOffset"), tag.m_128459_("leftRightMove"), tag.m_128471_("headLink"));
        this.customCarryPositions.set(0, this.custom);
    }

    public CPlayerCarrySyncPacket getSyncPacket(Player player) {
        return new CPlayerCarrySyncPacket(this.isCarried, this.isCarrying, this.currentCarryPos, this.customCarryPositions.get(0), player.m_20148_());
    }
}

