/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.events;

import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import com.ricardthegreat.holdmetight.size.PlayerSize;
import com.ricardthegreat.holdmetight.size.PlayerSizeProvider;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import virtuoel.pehkui.api.PehkuiConfig;

@Mod.EventBusSubscriber(modid="holdmetight", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeModEvents {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!((Entity)event.getObject()).getCapability(PlayerSizeProvider.PLAYER_SIZE).isPresent()) {
                event.addCapability(new ResourceLocation("holdmetight", "size"), (ICapabilityProvider)new PlayerSizeProvider());
            }
            if (!((Entity)event.getObject()).getCapability(PlayerCarryProvider.PLAYER_CARRY).isPresent()) {
                event.addCapability(new ResourceLocation("holdmetight", "carry"), (ICapabilityProvider)new PlayerCarryProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(PlayerSizeProvider.PLAYER_SIZE).ifPresent(oldStore -> event.getEntity().getCapability(PlayerSizeProvider.PLAYER_SIZE).ifPresent(newStore -> {
                if (((Boolean)PehkuiConfig.COMMON.keepAllScalesOnRespawn.get()).booleanValue()) {
                    newStore.copyAll((PlayerSize)oldStore);
                } else {
                    newStore.copyBasic((PlayerSize)oldStore);
                }
            }));
            event.getOriginal().getCapability(PlayerCarryProvider.PLAYER_CARRY).ifPresent(oldStore -> event.getEntity().getCapability(PlayerCarryProvider.PLAYER_CARRY).ifPresent(newStore -> newStore.copyFrom((PlayerCarry)oldStore)));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerSize.class);
        event.register(PlayerCarry.class);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player respawnPlayer = event.getEntity();
        Level level = respawnPlayer.m_9236_();
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            ServerPlayer serverJoiner = server.m_6846_().m_11259_(respawnPlayer.m_20148_());
            ForgeModEvents.syncPlayerCapabilities(serverJoiner, server);
        } else {
            for (Player player : level.m_6907_()) {
                System.out.println(player.m_7755_());
            }
        }
    }

    public static void syncPlayerCapabilities(ServerPlayer serverJoiner, MinecraftServer server) {
        Supplier<ServerPlayer> supplier = () -> serverJoiner;
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            LazyOptional CarryOptional;
            LazyOptional optional = player.getCapability(PlayerSizeProvider.PLAYER_SIZE);
            if (optional.isPresent()) {
                PlayerSize orElse = (PlayerSize)optional.orElse((Object)new PlayerSize());
                if (player == serverJoiner) {
                    PacketHandler.sendToAllClients(orElse.getSyncPacket((Player)player));
                } else {
                    PacketHandler.sendToPlayer(orElse.getSyncPacket((Player)player), supplier);
                }
            }
            if (!(CarryOptional = player.getCapability(PlayerCarryProvider.PLAYER_CARRY)).isPresent()) continue;
            PlayerCarry orElse = (PlayerCarry)CarryOptional.orElse((Object)new PlayerCarry());
            if (player == serverJoiner) {
                PacketHandler.sendToAllClients(orElse.getSyncPacket((Player)player));
                continue;
            }
            PacketHandler.sendToPlayer(orElse.getSyncPacket((Player)player), supplier);
        }
    }
}

