/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.mixins.climbing;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.utils.sizeutils.EntitySizeUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public class BlockClimbingMixin {
    @Shadow
    private Optional<BlockPos> f_20957_;

    @ModifyReturnValue(method={"onClimbable()Z"}, at={@At(value="RETURN")})
    public boolean onClimbable(boolean original) {
        LivingEntity ent = (LivingEntity)this;
        if (original) {
            if ((LivingEntity)this instanceof Player && PlayerCarryProvider.getPlayerCarryCapability((Player)this).getIsCarried()) {
                return false;
            }
            return original;
        }
        if (ent.m_5833_() || (double)EntitySizeUtils.getSize((Entity)ent) >= 0.8 || !(ent instanceof Player)) {
            return false;
        }
        if (this.checkForBlock(ent)) {
            this.f_20957_ = Optional.of(ent.m_20183_());
            return true;
        }
        return false;
    }

    private boolean checkForBlock(LivingEntity ent) {
        double bbradius = ent.m_20205_() / 2.0f;
        double xpos = ent.m_20182_().f_82479_;
        double zpos = ent.m_20182_().f_82481_;
        BlockPos playerBlockPos = ent.m_20183_();
        int bpx = playerBlockPos.m_123341_();
        int bpy = playerBlockPos.m_123342_();
        int bpz = playerBlockPos.m_123343_();
        int bpsouth = (int)Math.floor(zpos + bbradius);
        int bpeast = (int)Math.floor(xpos + bbradius);
        int bpnorth = (int)Math.floor(zpos - bbradius * 1.01);
        int bpwest = (int)Math.floor(xpos - bbradius * 1.01);
        Vec3i[] vecs = new Vec3i[]{new Vec3i(bpeast, bpy, bpz), new Vec3i(bpwest, bpy, bpz), new Vec3i(bpx, bpy, bpsouth), new Vec3i(bpx, bpy, bpnorth)};
        Level level = ent.m_9236_();
        for (int i = 0; i < 4; ++i) {
            BlockState state = level.m_8055_(new BlockPos(vecs[i]));
            if (!this.tinyCanClimb(state, ent)) continue;
            return true;
        }
        return false;
    }

    private boolean tinyCanClimb(BlockState state, LivingEntity ent) {
        if (!ent.f_19862_) {
            return false;
        }
        if (ent.m_21205_().m_150930_(Items.f_42518_) || ent.m_21206_().m_150930_(Items.f_42518_)) {
            return true;
        }
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || state.m_204336_(BlockTags.f_13089_) || state.m_204336_(BlockTags.f_215838_);
    }
}

