/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.network;

import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.network.CPlayerCarrySimplePacket;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SPlayerCarrySimplePacket {
    private final boolean carried;
    private final boolean carrying;
    private final int[] carryPos;
    private final UUID uuid;

    public SPlayerCarrySimplePacket(boolean carried, boolean carrying, int[] carryPos, UUID uuid) {
        this.carried = carried;
        this.carrying = carrying;
        this.carryPos = carryPos;
        this.uuid = uuid;
    }

    public SPlayerCarrySimplePacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean(), buffer.readBoolean(), new int[]{buffer.readInt(), buffer.readInt()}, buffer.m_130259_());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.carried);
        buffer.writeBoolean(this.carrying);
        buffer.writeInt(this.carryPos[0]);
        buffer.writeInt(this.carryPos[1]);
        buffer.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        PlayerCarry carry = PlayerCarryProvider.getPlayerCarryCapability((Player)player);
        if (carry != null) {
            carry.updateSimpleSyncables(this.carried, this.carrying, this.carryPos);
            PacketHandler.sendToAllClients(new CPlayerCarrySimplePacket(this.carried, this.carrying, this.carryPos, player.m_20148_()));
        }
    }
}

