/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.network;

import com.ricardthegreat.holdmetight.carry.CarryPosition;
import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import com.ricardthegreat.holdmetight.network.CPlayerCarrySyncPacket;
import com.ricardthegreat.holdmetight.network.PacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SPlayerCarrySyncPacket {
    private final boolean carried;
    private final boolean carrying;
    private final int[] carryPos;
    private final CarryPosition custom;

    public SPlayerCarrySyncPacket(boolean carried, boolean carrying, int[] carryPos, CarryPosition custom) {
        this.carried = carried;
        this.carrying = carrying;
        this.carryPos = carryPos;
        this.custom = custom;
    }

    public SPlayerCarrySyncPacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean(), buffer.readBoolean(), new int[]{buffer.readInt(), buffer.readInt()}, new CarryPosition(buffer.m_130277_(), buffer.readInt(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readBoolean()));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.carried);
        buffer.writeBoolean(this.carrying);
        buffer.writeInt(this.carryPos[0]);
        buffer.writeInt(this.carryPos[1]);
        buffer.m_130070_(this.custom.posName);
        buffer.writeInt(this.custom.RotationOffset);
        buffer.writeDouble(this.custom.leftRightMove);
        buffer.writeDouble(this.custom.vertOffset);
        buffer.writeDouble(this.custom.xymult);
        buffer.writeBoolean(this.custom.headLink);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        PlayerCarry carry = PlayerCarryProvider.getPlayerCarryCapability((Player)player);
        if (carry != null) {
            carry.updateAllSyncables(this.carried, this.carrying, this.carryPos, this.custom);
            PacketHandler.sendToAllClients(new CPlayerCarrySyncPacket(this.carried, this.carrying, this.carryPos, this.custom, player.m_20148_()));
        }
    }
}

