/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.network;

import com.ricardthegreat.holdmetight.carry.PlayerCarry;
import com.ricardthegreat.holdmetight.carry.PlayerCarryProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SPlayerPutDownPacket {
    private final UUID uuid;
    private final Vec3 pos;

    public SPlayerPutDownPacket(UUID uuid, Vec3 pos) {
        this.uuid = uuid;
        this.pos = pos;
    }

    public SPlayerPutDownPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130259_(), new Vec3(buffer.m_269394_()));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_269582_(this.pos.m_252839_());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vec3 getVec3() {
        return this.pos;
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        ServerPlayer target = player.f_8924_.m_6846_().m_11259_(this.uuid);
        if (target != null) {
            PlayerCarry playerCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)player);
            PlayerCarry targetCarry = PlayerCarryProvider.getPlayerCarryCapability((Player)target);
            playerCarry.setCarrying(false);
            playerCarry.setShouldSyncSimple(true);
            targetCarry.setCarried(false);
            targetCarry.setShouldSyncSimple(true);
            target.m_142098_(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_);
        }
    }
}

