/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.size;

import com.ricardthegreat.holdmetight.size.PlayerSize;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSizeProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerSize> PLAYER_SIZE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerSize>(){});
    private PlayerSize size = null;
    private final LazyOptional<PlayerSize> optional = LazyOptional.of(this::createPlayerSize);

    private PlayerSize createPlayerSize() {
        if (this.size == null) {
            this.size = new PlayerSize();
        }
        return this.size;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createPlayerSize().saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.createPlayerSize().loadNBTData(tag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == PLAYER_SIZE) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public static PlayerSize getPlayerSizeCapability(Player player) {
        LazyOptional optional = player.getCapability(PLAYER_SIZE);
        return (PlayerSize)optional.orElse((Object)new PlayerSize());
    }
}

