/*
 * Decompiled with CFR 0.152.
 */
package com.ricardthegreat.holdmetight.worldgen.structures;

import com.ricardthegreat.holdmetight.blockentities.MushroomTeleporterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

public class MushroomHouseStructureGenerator {
    public static boolean generated = false;

    public static void generateMushroomHouseStructure(LevelAccessor level, MushroomTeleporterBlockEntity house) {
        BlockPos pos = new BlockPos(house.getHousePos());
        System.out.println("does this print before the lag starts?");
        MushroomHouseStructureGenerator.genFloor(level, pos);
        System.out.println("floor done");
        MushroomHouseStructureGenerator.genWalls(level, pos);
        System.out.println("walls done");
        MushroomHouseStructureGenerator.genWallCorners(level, pos);
        System.out.println("wall corners done");
        MushroomHouseStructureGenerator.genSecondFloor(level, pos);
        System.out.println("second floor done");
        MushroomHouseStructureGenerator.genCap(level, pos);
        System.out.println("cap done");
        MushroomHouseStructureGenerator.genCapCorners(level, pos);
        System.out.println("cap corners done");
    }

    private static void genFloor(LevelAccessor level, BlockPos pos) {
        AABB floor = new AABB(pos, pos).m_82377_(5.0, 0.0, 5.0);
        BlockPos.m_121921_((AABB)floor).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50440_.m_49966_(), 0));
    }

    private static void genWalls(LevelAccessor level, BlockPos pos) {
        pos = pos.m_6630_(4);
        BlockPos posEast = pos.m_122030_(6);
        BlockPos posWest = pos.m_122025_(6);
        BlockPos posNorth = pos.m_122013_(6);
        BlockPos posSouth = pos.m_122020_(6);
        AABB eastWall = new AABB(posEast, posEast).m_82377_(0.0, 3.0, 2.0);
        AABB westWall = new AABB(posWest, posWest).m_82377_(0.0, 3.0, 2.0);
        AABB northWall = new AABB(posNorth, posNorth).m_82377_(2.0, 3.0, 0.0);
        AABB southWall = new AABB(posSouth, posSouth).m_82377_(2.0, 3.0, 0.0);
        BlockPos.m_121921_((AABB)eastWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
        BlockPos.m_121921_((AABB)westWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
        BlockPos.m_121921_((AABB)northWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
        BlockPos.m_121921_((AABB)southWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
    }

    private static void genWallCorners(LevelAccessor level, BlockPos pos) {
        for (int j = 3; j < 6; ++j) {
            BlockPos posNorthEast = pos.m_122013_(j).m_122030_(8 - j);
            BlockPos posNorthWest = pos.m_122013_(j).m_122025_(8 - j);
            BlockPos posSouthEast = pos.m_122020_(j).m_122030_(8 - j);
            BlockPos posSouthWest = pos.m_122020_(j).m_122025_(8 - j);
            AABB eastWall = new AABB(posNorthEast, posNorthEast.m_6630_(6));
            AABB westWall = new AABB(posNorthWest, posNorthWest.m_6630_(6));
            AABB northWall = new AABB(posSouthEast, posSouthEast.m_6630_(6));
            AABB southWall = new AABB(posSouthWest, posSouthWest.m_6630_(6));
            BlockPos.m_121921_((AABB)eastWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)westWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)northWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)southWall).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50182_.m_49966_(), 0));
        }
    }

    private static void genSecondFloor(LevelAccessor level, BlockPos pos) {
        int j;
        pos = pos.m_6630_(7);
        AABB centre = new AABB(pos, pos).m_82377_(2.0, 0.0, 10.0);
        AABB centreHole = new AABB(pos, pos).m_82377_(2.0, 0.0, 5.0);
        BlockPos.m_121921_((AABB)centre).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
        BlockPos.m_121921_((AABB)centreHole).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50016_.m_49966_(), 0));
        BlockPos posEast = pos.m_122030_(7);
        BlockPos posWest = pos.m_122025_(7);
        AABB east = new AABB(posEast.m_122020_(10), posEast.m_122013_(10).m_122024_());
        AABB west = new AABB(posWest.m_122020_(10), posWest.m_122013_(10).m_122029_());
        BlockPos.m_121921_((AABB)east).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
        BlockPos.m_121921_((AABB)west).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
        for (j = 3; j < 6; ++j) {
            posEast = pos.m_122030_(j);
            posWest = pos.m_122025_(j);
            east = new AABB(posEast, posEast).m_82377_(0.0, 0.0, 10.0);
            west = new AABB(posWest, posWest).m_82377_(0.0, 0.0, 10.0);
            AABB eastHole = new AABB(posEast, posEast).m_82377_(0.0, 0.0, (double)(7 - j));
            AABB westHole = new AABB(posWest, posWest).m_82377_(0.0, 0.0, (double)(7 - j));
            BlockPos.m_121921_((AABB)east).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)west).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)eastHole).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50016_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)westHole).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50016_.m_49966_(), 0));
        }
        for (j = 8; j < 11; ++j) {
            posEast = pos.m_122030_(j);
            posWest = pos.m_122025_(j);
            east = new AABB(posEast, posEast).m_82377_(0.0, 0.0, (double)(17 - j));
            west = new AABB(posWest, posWest).m_82377_(0.0, 0.0, (double)(17 - j));
            BlockPos.m_121921_((AABB)east).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
            BlockPos.m_121921_((AABB)west).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
        }
    }

    private static void genCap(LevelAccessor level, BlockPos pos) {
        pos = pos.m_6630_(8);
        AABB top = new AABB(pos, pos).m_82377_(11.0, 0.0, 11.0);
        AABB topHole = new AABB(pos, pos).m_82377_(10.0, 0.0, 10.0);
        BlockPos.m_121921_((AABB)top).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
        BlockPos.m_121921_((AABB)topHole).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50016_.m_49966_(), 0));
        pos = pos.m_6630_(7);
        int[] widths = new int[]{2, 5, 7, 8, 9, 10, 11};
        int prevWidth = 0;
        for (int j = 0; j < 7; ++j) {
            top = new AABB(pos.m_6625_(j), pos.m_6625_(j)).m_82377_((double)widths[j], 0.0, (double)widths[j]);
            topHole = new AABB(pos.m_6625_(j), pos.m_6625_(j)).m_82377_((double)prevWidth, 0.0, (double)prevWidth);
            BlockPos.m_121921_((AABB)top).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
            if (j != 0) {
                BlockPos.m_121921_((AABB)topHole).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50016_.m_49966_(), 0));
            }
            prevWidth = widths[j];
        }
    }

    private static void genCapCorners(LevelAccessor level, BlockPos pos) {
        AABB corner;
        int k;
        int j;
        BlockPos posNE = pos = pos.m_6630_(8);
        BlockPos posNW = pos;
        BlockPos posSE = pos;
        BlockPos posSW = pos;
        BlockPos[] posList = new BlockPos[]{posNE, posNW, posSE, posSW};
        for (j = 8; j < 11; ++j) {
            posList[0] = pos.m_122013_(j).m_122030_(18 - j);
            posList[1] = pos.m_122013_(j).m_122025_(18 - j);
            posList[2] = pos.m_122020_(j).m_122030_(18 - j);
            posList[3] = pos.m_122020_(j).m_122025_(18 - j);
            for (k = 0; k < 4; ++k) {
                corner = new AABB(posList[k], posList[k].m_7494_());
                BlockPos.m_121921_((AABB)corner).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
            }
        }
        pos = pos.m_6630_(2);
        for (j = 8; j < 10; ++j) {
            posList[0] = pos.m_122013_(j).m_122030_(17 - j);
            posList[1] = pos.m_122013_(j).m_122025_(17 - j);
            posList[2] = pos.m_122020_(j).m_122030_(17 - j);
            posList[3] = pos.m_122020_(j).m_122025_(17 - j);
            for (k = 0; k < 4; ++k) {
                corner = new AABB(posList[k], posList[k]);
                BlockPos.m_121921_((AABB)corner).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
            }
        }
        pos = pos.m_7494_();
        posList[0] = pos.m_122013_(8).m_122030_(8);
        posList[1] = pos.m_122013_(8).m_122025_(8);
        posList[2] = pos.m_122020_(8).m_122030_(8);
        posList[3] = pos.m_122020_(8).m_122025_(8);
        for (j = 0; j < 4; ++j) {
            AABB corner2 = new AABB(posList[j], posList[j]);
            BlockPos.m_121921_((AABB)corner2).map(BlockPos::m_7949_).forEach(i -> level.m_7731_(i, Blocks.f_50181_.m_49966_(), 0));
        }
    }
}

