/*
 * Decompiled with CFR 0.152.
 */
package hu.ris.roofify.render;

import hu.ris.roofify.configuration.RoofifyConfigLoader;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@Environment(value=EnvType.CLIENT)
public class RenderUtils {
    public static void draw(class_4587 matrices, class_327 textRenderer, class_4597.class_4598 bufferSource, class_2338 positionToDraw, Quaternionf cameraRotation, String textToDraw, float textScale, int textColor, float textOffsetY) {
        matrices.method_22903();
        matrices.method_22904((double)positionToDraw.method_10263() + 0.5, (double)((float)positionToDraw.method_10264() + textOffsetY), (double)positionToDraw.method_10260() + 0.5);
        matrices.method_22907(cameraRotation);
        matrices.method_22905(textScale, -textScale, textScale);
        float textWidth = textRenderer.method_1727(textToDraw);
        Matrix4f positionMatrix = matrices.method_23760().method_23761();
        float f = -textWidth / 2.0f;
        Objects.requireNonNull(textRenderer);
        textRenderer.method_27521(textToDraw, f, (float)(-9) / 2.0f, textColor, true, positionMatrix, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        matrices.method_22909();
    }

    public static float getTextOffsetY(Optional<class_238> blockBoundingBoxDrawAt, float textWidthScaled, float textHeightScaled) {
        float textOffsetY = 0.1f;
        if (blockBoundingBoxDrawAt.isPresent()) {
            float textMaxLength = (float)Math.hypot(textWidthScaled, textHeightScaled);
            boolean textOverlapped = blockBoundingBoxDrawAt.get().method_1003((double)(0.5f - textMaxLength / 2.0f), 0.0, (double)(0.5f - textMaxLength / 2.0f), (double)(0.5f + textMaxLength / 2.0f), (double)textHeightScaled, (double)(0.5f + textMaxLength / 2.0f));
            if (textOverlapped) {
                textOffsetY += (float)blockBoundingBoxDrawAt.get().method_17940();
            }
        }
        return textOffsetY;
    }

    public static boolean shouldRender(WorldRenderContext worldRenderContext) {
        if (!RoofifyConfigLoader.config.enabled) {
            return false;
        }
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1724 == null || client.field_1687 == null || client.field_1772 == null) {
            return false;
        }
        class_4587 matrices = worldRenderContext.matrixStack();
        if (matrices == null) {
            return false;
        }
        class_638 world = worldRenderContext.world();
        class_5321 worldKey = world.method_27983();
        boolean isInNether = worldKey.equals(class_1937.field_25180);
        if (!isInNether) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        double yLevel = player.method_23318();
        return !(yLevel < 125.0);
    }
}

