/*
 * Decompiled with CFR 0.152.
 */
package hu.ris.roofify.configuration;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.YamlWriter;
import hu.ris.roofify.configuration.RoofifyConfigLoader;
import hu.ris.roofify.render.RenderMode;
import hu.ris.roofify.render.modes.RenderModeType;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class RoofifyConfig {
    public boolean enabled = true;
    public boolean include_roof_level = false;
    public RenderModeType render_mode = RenderModeType.CHECKMARK;
    public int render_interval = 20;
    public int render_distance_horizontal = 8;
    public int render_distance_vertical = 4;

    protected RoofifyConfig() {
    }

    public RenderMode getRenderMode() {
        return RenderMode.getByType(this.render_mode);
    }

    public boolean toggleRoofLevel() {
        this.include_roof_level = !this.include_roof_level;
        this.save();
        return this.include_roof_level;
    }

    public void setRenderMode(RenderMode renderMode) {
        this.render_mode = renderMode.getType();
        this.save();
    }

    public RenderMode cycleRenderMode() {
        List<RenderMode> renderModes = RenderMode.getRenderModes();
        RenderMode[] renderModeArray = renderModes.toArray(new RenderMode[0]);
        RenderMode currentRenderMode = this.getRenderMode();
        int currentIndex = -1;
        for (int i = 0; i < renderModeArray.length; ++i) {
            if (!renderModeArray[i].getType().equals((Object)currentRenderMode.getType())) continue;
            currentIndex = i;
            break;
        }
        int nextIndex = (currentIndex + 1) % renderModeArray.length;
        RenderMode nextRenderMode = renderModeArray[nextIndex];
        this.setRenderMode(nextRenderMode);
        return this.getRenderMode();
    }

    public boolean toggleEnabled() {
        this.enabled = !this.enabled;
        this.save();
        return this.enabled;
    }

    public int setHorizontalRadius(int horizontalRadius) {
        this.render_distance_horizontal = horizontalRadius;
        this.save();
        return this.render_distance_horizontal;
    }

    public int setVerticalRadius(int verticalRadius) {
        this.render_distance_vertical = verticalRadius;
        this.save();
        return this.render_distance_vertical;
    }

    public RoofifyConfig load() {
        RoofifyConfig roofifyConfig;
        if (!RoofifyConfigLoader.FILE.exists()) {
            RoofifyConfig config = new RoofifyConfig();
            config.save();
            return config;
        }
        FileReader reader = new FileReader(RoofifyConfigLoader.FILE);
        try {
            YamlConfig yamlConfig = new YamlConfig();
            YamlReader yamlReader = new YamlReader((Reader)reader, yamlConfig);
            RoofifyConfig config = (RoofifyConfig)yamlReader.read(RoofifyConfig.class);
            yamlReader.close();
            roofifyConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new RoofifyConfig();
            }
        }
        reader.close();
        return roofifyConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(RoofifyConfigLoader.FILE);){
            YamlConfig yamlConfig = new YamlConfig();
            yamlConfig.writeConfig.setVersion(null);
            yamlConfig.writeConfig.setExplicitFirstDocument(false);
            yamlConfig.writeConfig.setWriteRootTags(false);
            yamlConfig.writeConfig.setWriteDefaultValues(true);
            yamlConfig.writeConfig.setWriteClassname(YamlConfig.WriteClassName.NEVER);
            yamlConfig.writeConfig.setKeepBeanPropertyOrder(true);
            YamlWriter yamlWriter = new YamlWriter((Writer)writer, yamlConfig);
            yamlWriter.write((Object)this);
            yamlWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save Roofify's configuration file: ", e);
        }
    }
}

