/*
 * Decompiled with CFR 0.152.
 */
package hu.ris.roofify.render;

import hu.ris.roofify.configuration.RoofifyConfigLoader;
import hu.ris.roofify.render.CachedBlock;
import hu.ris.roofify.render.RenderMode;
import hu.ris.roofify.render.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class RoofifyRender {
    private static final int maxY = 127;
    private static final int maxMinY = 123;
    private static final List<CachedBlock> blocksCached = new ArrayList<CachedBlock>();
    protected static int frames = 0;

    public static int getMaxY() {
        return 127;
    }

    public static int getMaxMinY() {
        return 123;
    }

    public static void render(WorldRenderContext worldRenderContext) {
        if (!RenderUtils.shouldRender(worldRenderContext)) {
            return;
        }
        class_310 client = class_310.method_1551();
        int renderInterval = RoofifyConfigLoader.config.render_interval;
        class_638 world = client.field_1687;
        Optional<class_4604> frustum = Optional.ofNullable(worldRenderContext.frustum());
        class_327 gameTextRenderer = client.field_1772;
        class_746 player = client.field_1724;
        class_2338 playerPosition = player.method_24515();
        class_4184 camera = worldRenderContext.camera();
        class_243 cameraPosition = camera.method_19326();
        class_4587 matrices = worldRenderContext.matrixStack();
        if (++frames >= renderInterval) {
            RoofifyRender.getRenderTargets((class_1937)world, (class_1657)player, frustum, gameTextRenderer, playerPosition, cameraPosition);
            frames = 0;
        }
        matrices.method_22903();
        matrices.method_22904(-cameraPosition.field_1352, -cameraPosition.field_1351, -cameraPosition.field_1350);
        class_4597.class_4598 bufferSource = client.method_22940().method_23000();
        Quaternionf cameraRotation = new Quaternionf((Quaternionfc)camera.method_23767());
        for (CachedBlock target : blocksCached) {
            RenderUtils.draw(matrices, gameTextRenderer, bufferSource, target.position, cameraRotation, target.text, target.textScale, target.textColor, target.textOffsetY);
        }
        matrices.method_22909();
    }

    private static void getRenderTargets(class_1937 world, class_1657 player, Optional<class_4604> frustum, class_327 textRenderer, class_2338 playerPosition, class_243 cameraPosition) {
        blocksCached.clear();
        class_2338.class_2339 positionToRenderAt = new class_2338.class_2339();
        int renderRangeHorizontal = RoofifyConfigLoader.config.render_distance_horizontal;
        int renderRangeVertical = RoofifyConfigLoader.config.render_distance_vertical;
        double maxSquaredDistance = (double)(renderRangeHorizontal * renderRangeHorizontal) * 1.5;
        for (int dx = -renderRangeHorizontal; dx <= renderRangeHorizontal; ++dx) {
            for (int dz = -renderRangeHorizontal; dz <= renderRangeHorizontal; ++dz) {
                for (int dy = -renderRangeVertical; dy <= renderRangeVertical; ++dy) {
                    int maxYlevel;
                    class_2338 blockPosRenderAt;
                    class_2248 blockRenderAtType;
                    class_2680 blockStateRenderAt;
                    positionToRenderAt.method_10103(playerPosition.method_10263() + dx, playerPosition.method_10264() + dy, playerPosition.method_10260() + dz);
                    if (positionToRenderAt.method_10262((class_2382)playerPosition) > maxSquaredDistance || (blockStateRenderAt = world.method_8320((class_2338)positionToRenderAt)).method_26215() || !(blockRenderAtType = blockStateRenderAt.method_26204()).equals(class_2246.field_9987) || (blockPosRenderAt = positionToRenderAt.method_10062()).method_10264() != 127) continue;
                    ArrayList<class_2680> blocksBelow = new ArrayList<class_2680>();
                    for (int y = maxYlevel = RoofifyConfigLoader.config.include_roof_level ? 127 : 126; y >= 123; --y) {
                        class_2338 checkPos = new class_2338(blockPosRenderAt.method_10263(), y, blockPosRenderAt.method_10260());
                        class_2680 checkBlockState = world.method_8320(checkPos);
                        blocksBelow.add(checkBlockState);
                    }
                    RenderMode renderMode = RoofifyConfigLoader.config.getRenderMode();
                    String text = renderMode.getDisplayText(blocksBelow);
                    int textColor = -16711936;
                    class_265 blockVisualShapeRenderAt = blockStateRenderAt.method_26218((class_1922)world, (class_2338)positionToRenderAt);
                    Optional<Object> blockBoundingBoxRenderAt = blockVisualShapeRenderAt.method_1110() ? Optional.empty() : Optional.of(blockVisualShapeRenderAt.method_1107());
                    String textToRender = text;
                    float textScale = renderMode.getTextScale();
                    float textWidthScaled = (float)textRenderer.method_1727(textToRender) * textScale;
                    Objects.requireNonNull(textRenderer);
                    float textHeightScaled = 9.0f * textScale;
                    float textOffsetY = RenderUtils.getTextOffsetY(blockBoundingBoxRenderAt, textWidthScaled, textHeightScaled);
                    blocksCached.add(new CachedBlock(positionToRenderAt.method_10062(), textToRender, textScale, textColor, textOffsetY));
                }
            }
        }
    }
}

