/*
 * Decompiled with CFR 0.152.
 */
package hu.ris.roofify.render;

import hu.ris.roofify.render.modes.CheckmarkMode;
import hu.ris.roofify.render.modes.CountBedrocksBreakMode;
import hu.ris.roofify.render.modes.CountBedrocksMode;
import hu.ris.roofify.render.modes.RenderModeType;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2680;

@Environment(value=EnvType.CLIENT)
public abstract class RenderMode {
    private static final List<RenderMode> RENDER_TYPES = new ArrayList<RenderMode>();
    private final RenderModeType type;

    public RenderMode(RenderModeType type) {
        this.type = type;
        RENDER_TYPES.add(this);
    }

    public RenderModeType getType() {
        return this.type;
    }

    public abstract float getTextScale();

    public abstract String getDisplayText(List<class_2680> var1);

    public static List<RenderMode> getRenderModes() {
        return RENDER_TYPES;
    }

    public static RenderMode getDefault() {
        return RenderMode.getByType(RenderModeType.CHECKMARK);
    }

    public static RenderMode getByType(RenderModeType type) {
        for (RenderMode renderMode : RENDER_TYPES) {
            if (!renderMode.getType().equals((Object)type)) continue;
            return renderMode;
        }
        return RenderMode.getDefault();
    }

    public static void init() {
        new CheckmarkMode();
        new CountBedrocksMode();
        new CountBedrocksBreakMode();
    }
}

