/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysPlayerHeadDrops;

import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.damage.DamageSource;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerDeathListener
implements Listener {
    Plugin plugin;

    public PlayerDeathListener(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        SkullMeta playerHeadMeta;
        ItemStack playerHead;
        DamageSource source = event.getDamageSource();
        Player deadPlayer = event.getPlayer();
        Player cause = deadPlayer.getKiller();
        if (cause == null) {
            Entity entity = event.getDamageSource().getCausingEntity();
            if (entity instanceof Player) {
                Player playerCause;
                cause = playerCause = (Player)entity;
            } else {
                return;
            }
        }
        if (cause.getName().equals(deadPlayer.getName())) {
            playerHead = new ItemStack(Material.PLAYER_HEAD);
            playerHeadMeta = (SkullMeta)playerHead.getItemMeta();
            NamespacedKey key = new NamespacedKey(this.plugin, "is_sterile_head");
            playerHeadMeta.getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)true);
            playerHeadMeta.lore(List.of(Component.text((String)"Decorative")));
            playerHeadMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)deadPlayer.getName()));
            playerHead.setItemMeta((ItemMeta)playerHeadMeta);
            event.getDrops().add(playerHead);
            return;
        }
        cause.giveExp(event.getDroppedExp(), true);
        event.setDroppedExp(0);
        playerHead = new ItemStack(Material.PLAYER_HEAD);
        playerHeadMeta = (SkullMeta)playerHead.getItemMeta();
        playerHeadMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)deadPlayer.getName()));
        playerHead.setItemMeta((ItemMeta)playerHeadMeta);
        cause.give(new ItemStack[]{playerHead});
    }
}

