/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysPlayerHeadDrops;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class APIManager {
    Plugin plugin;
    File livesFile;

    public APIManager(Plugin plugin) {
        this.plugin = plugin;
        this.livesFile = new File(plugin.getDataFolder(), "lives.yml");
    }

    public void removeLife(String playerName) throws IOException {
        if (this.lifeSystemDisabled()) {
            return;
        }
        YamlConfiguration lives = YamlConfiguration.loadConfiguration((File)this.livesFile);
        int playerLives = this.getLives(playerName);
        this.setLives(playerName, Math.max(playerLives - 1, 0));
    }

    public void addLife(String playerName) throws IOException {
        if (this.lifeSystemDisabled()) {
            return;
        }
        YamlConfiguration lives = YamlConfiguration.loadConfiguration((File)this.livesFile);
        int playerLives = this.getLives(playerName);
        this.setLives(playerName, Math.max(playerLives + 1, 0));
    }

    public int getLives(String playerName) {
        YamlConfiguration lives = YamlConfiguration.loadConfiguration((File)this.livesFile);
        return lives.get("lives." + playerName) != null ? lives.getInt("lives." + playerName) : this.plugin.getConfig().getInt("lifeSystem.maxLives");
    }

    public void setLives(String playerName, int playerLives) throws IOException {
        YamlConfiguration lives = YamlConfiguration.loadConfiguration((File)this.livesFile);
        lives.set("lives." + playerName, (Object)playerLives);
        lives.save(this.livesFile);
    }

    public void revive(String playerName) throws IOException {
        if (this.lifeSystemDisabled()) {
            return;
        }
        this.setLives(playerName, this.plugin.getConfig().getInt("lifeSystem.maxLives"));
    }

    public boolean lifeSystemDisabled() {
        return !this.plugin.getConfig().getBoolean("lifeSystem.enabled");
    }
}

