/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysCombatTweaks;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;

public class EntityDamagedListener
implements Listener {
    Plugin plugin;
    File dataFile;
    YamlConfiguration config;

    public EntityDamagedListener(Plugin plugin) {
        this.plugin = plugin;
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        this.dataFile = new File(plugin.getDataFolder(), "combat_data.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    @EventHandler
    public void onEntityDamagedByEntity(EntityDamageByEntityEvent event) throws IOException {
        if (event.getEntity() instanceof Player && event.getDamager() instanceof Player) {
            List damagerInCombatWith;
            List entityInCombatWith;
            YamlConfiguration combatData = YamlConfiguration.loadConfiguration((File)this.dataFile);
            String damagerLastHit = combatData.getString("combat.lastHits." + event.getDamager().getName());
            String entityLastHit = combatData.getString("combat.lastHits." + event.getEntity().getName());
            if (entityLastHit != null && Instant.parse(entityLastHit).plusSeconds(this.config.getLong("combatEndDelay")).isBefore(Instant.now())) {
                event.getEntity().sendActionBar((Component)Component.text((String)"You are in combat."));
                combatData.set("combat.goldenApplesUsed." + event.getEntity().getName(), (Object)0);
                combatData.set("combat.with." + event.getEntity().getName(), List.of());
            }
            if (damagerLastHit != null && Instant.parse(damagerLastHit).plusSeconds(this.config.getLong("combatEndDelay")).isBefore(Instant.now())) {
                event.getDamager().sendActionBar((Component)Component.text((String)"You are in combat."));
                combatData.set("combat.goldenApplesUsed." + event.getDamager().getName(), (Object)0);
                combatData.set("combat.with." + event.getDamager().getName(), List.of());
            }
            if (!(entityInCombatWith = combatData.getStringList("combat.with." + event.getEntity().getName())).contains(event.getDamager().getName())) {
                entityInCombatWith.add(event.getDamager().getName());
                combatData.set("combat.with." + event.getEntity().getName(), (Object)entityInCombatWith);
            }
            if (!(damagerInCombatWith = combatData.getStringList("combat.with." + event.getDamager().getName())).contains(event.getEntity().getName())) {
                damagerInCombatWith.add(event.getEntity().getName());
                combatData.set("combat.with." + String.valueOf(event.getDamager()), (Object)damagerInCombatWith);
            }
            String now = Instant.now().toString();
            combatData.set("combat.lastHits." + event.getEntity().getName(), (Object)now);
            combatData.set("combat.lastHits." + event.getDamager().getName(), (Object)now);
            combatData.save(this.dataFile);
        }
    }
}

