/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysCombatTweaks;

import io.papermc.paper.event.player.PlayerItemCooldownEvent;
import java.io.File;
import java.time.Instant;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ItemCooldownListener
implements Listener {
    Plugin plugin;
    File dataFile;
    YamlConfiguration config;

    public ItemCooldownListener(Plugin plugin) {
        this.plugin = plugin;
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        this.dataFile = new File(plugin.getDataFolder(), "combat_data.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    @EventHandler
    public void onItemCooldown(PlayerItemCooldownEvent event) {
        if (event.getType() != Material.ENDER_PEARL) {
            return;
        }
        YamlConfiguration combatData = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (combatData.getString("combat.lastHits." + event.getPlayer().getName()) == null) {
            event.setCooldown(this.config.getInt("enderPealCooldown"));
            return;
        }
        if (Instant.parse(combatData.getString("combat.lastHits." + event.getPlayer().getName())).plusSeconds(this.config.getLong("combatEndDelay")).isAfter(Instant.now())) {
            event.setCooldown(this.config.getInt("battleEnderPearlCooldown"));
        } else {
            event.setCooldown(this.config.getInt("enderPealCooldown"));
        }
    }
}

