/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysCombatTweaks;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class PlayerDeathListener
implements Listener {
    Plugin plugin;
    File dataFile;
    YamlConfiguration config;

    public PlayerDeathListener(Plugin plugin) {
        this.plugin = plugin;
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        this.dataFile = new File(plugin.getDataFolder(), "combat_data.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) throws IOException {
        YamlConfiguration combatData = YamlConfiguration.loadConfiguration((File)this.dataFile);
        String entityLastHit = combatData.getString("combat.lastHits." + event.getPlayer().getName());
        if (entityLastHit != null && Instant.parse(entityLastHit).plusSeconds(this.config.getLong("combatEndDelay")).isBefore(Instant.now())) {
            combatData.set("combat.lastHits." + event.getPlayer().getName(), (Object)Instant.ofEpochMilli(0L));
            List inCombatWith = combatData.getStringList("combat.with." + String.valueOf(event.getPlayer()));
            for (String playerName : inCombatWith) {
                List combatWith = combatData.getStringList("combat.with." + playerName);
                combatWith.remove(event.getPlayer().getName());
                combatData.set("combat.with." + playerName, (Object)combatWith);
                if (!combatWith.isEmpty()) continue;
                combatData.set("combat.lastHits." + playerName, (Object)Instant.ofEpochMilli(0L));
            }
            combatData.save(this.dataFile);
        }
    }
}

