/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysPlayerHeadDrops;

import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class NBTCraftingRecipe
implements Listener {
    BiFunction<Plugin, ItemStack[], ItemStack> resolve;
    Plugin plugin;
    Material[] pattern;
    String pluginSpecificID;

    public NBTCraftingRecipe(String pluginSpecificID, BiFunction<Plugin, ItemStack[], ItemStack> resolve, Plugin plugin, Material[] pattern) {
        this.resolve = resolve;
        this.plugin = plugin;
        this.pattern = pattern;
        this.pluginSpecificID = pluginSpecificID;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        ItemStack[] craftingGrid = event.getInventory().getMatrix();
        for (int i = 0; i < 9; ++i) {
            Material patternItem;
            ItemStack gridItem = craftingGrid[i];
            if (gridItem == null & (patternItem = this.pattern[i]) == null) continue;
            if (gridItem == null || patternItem == null) {
                return;
            }
            if (gridItem.getType() == patternItem) continue;
            return;
        }
        event.getInventory().setResult(this.resolve.apply(this.plugin, craftingGrid));
    }

    public void register() {
        NamespacedKey key = new NamespacedKey(this.plugin, "WarriorSword");
        ItemStack item = ItemStack.of((Material)Material.DIRT);
        ShapedRecipe recipe = new ShapedRecipe(key, item);
        recipe.shape(new String[]{"ABC", "DEF", "GHI"});
        recipe.setIngredient('A', this.pattern[0]);
        recipe.setIngredient('B', this.pattern[1]);
        recipe.setIngredient('C', this.pattern[2]);
        recipe.setIngredient('D', this.pattern[3]);
        recipe.setIngredient('E', this.pattern[4]);
        recipe.setIngredient('F', this.pattern[5]);
        recipe.setIngredient('G', this.pattern[6]);
        recipe.setIngredient('H', this.pattern[7]);
        recipe.setIngredient('I', this.pattern[8]);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
    }
}

