/*
 * Decompiled with CFR 0.152.
 */
package dev.Pigly3.piglysPlayerHeadDrops;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerInteractListener
implements Listener {
    Plugin plugin;
    File file;
    YamlConfiguration config;

    public PlayerInteractListener(Plugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "cooldowns.yml");
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        ItemStack item = event.getItem();
        if (item == null || item.getItemMeta() == null || !item.hasItemMeta()) {
            return;
        }
        if (item.getType() == Material.PLAYER_HEAD) {
            SkullMeta headMeta = (SkullMeta)item.getItemMeta();
            PlayerProfile headOwner = Objects.requireNonNull(headMeta.getPlayerProfile());
            if (headOwner == null) {
                return;
            }
            if (headOwner.getName().equals(event.getPlayer().getName())) {
                return;
            }
            NamespacedKey key = new NamespacedKey(this.plugin, "is_disguise_head");
            if (Boolean.TRUE.equals(item.getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.BOOLEAN))) {
                this.plugin.getLogger().info("used disguise head");
                this.disguiseHeadInteract(event, headOwner);
                return;
            }
            Player owner = Bukkit.getPlayer((String)headOwner.getName());
            if (owner == null || !owner.canSee(event.getPlayer())) {
                return;
            }
            key = new NamespacedKey(this.plugin, "is_sterile_head");
            if (Boolean.TRUE.equals(item.getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.BOOLEAN))) {
                return;
            }
            YamlConfiguration cooldowns = YamlConfiguration.loadConfiguration((File)this.file);
            if (cooldowns.get("players." + event.getPlayer().getName()) != null) {
                if (Instant.parse((CharSequence)Objects.requireNonNull(cooldowns.get("players." + event.getPlayer().getName()))).isAfter(Instant.now())) {
                    event.getPlayer().sendActionBar((Component)Component.text((String)String.format("\u00a7cCooldown: %ss", Math.round(Duration.between(Instant.now(), Instant.parse((CharSequence)Objects.requireNonNull(cooldowns.get("players." + event.getPlayer().getName())))).getSeconds()))));
                    return;
                }
                owner.hidePlayer(this.plugin, event.getPlayer());
                if (this.config.getBoolean("removeHeadOnUse")) {
                    item.setAmount(item.getAmount() - 1);
                }
                event.setCancelled(true);
                event.getPlayer().sendActionBar((Component)Component.text((String)String.format("You are invisible to %s", headOwner.getName())));
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                    if (!owner.canSee(event.getPlayer())) {
                        owner.showPlayer(this.plugin, event.getPlayer());
                        event.getPlayer().sendActionBar((Component)Component.text((String)String.format("%s can now see you", headOwner.getName())));
                        cooldowns.set("players." + event.getPlayer().getName(), (Object)Instant.now().plusSeconds(20L).toString());
                        try {
                            cooldowns.save(this.file);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }, 1200L);
            } else {
                owner.hidePlayer(this.plugin, event.getPlayer());
                item.setAmount(item.getAmount() - 1);
                event.getPlayer().sendActionBar((Component)Component.text((String)String.format("You are invisible to %s", headOwner.getName())));
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                    if (!owner.canSee(event.getPlayer())) {
                        owner.showPlayer(this.plugin, event.getPlayer());
                        event.getPlayer().sendActionBar((Component)Component.text((String)String.format("%s can now see you", headOwner.getName())));
                        cooldowns.set("players." + event.getPlayer().getName(), (Object)Instant.now().plusSeconds(this.config.getInt("headUseCooldown")).toString());
                        try {
                            cooldowns.save(this.file);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }, 20L * (long)this.config.getInt("headUseDuration"));
            }
        }
    }

    public void disguiseHeadInteract(PlayerInteractEvent event, PlayerProfile owner) {
        Player player = event.getPlayer();
        PlayerProfile profile = player.getPlayerProfile();
        PlayerProfile returnProfile = (PlayerProfile)profile.clone();
        String playerName = player.getName();
        for (ProfileProperty property : owner.getProperties()) {
            if (!"textures".equals(property.getName())) continue;
            profile.setProperty(property);
        }
        UUID playerUUID = player.getUniqueId();
        player.setPlayerProfile(profile);
        player.displayName((Component)Component.text((String)owner.getName()));
        player.playerListName((Component)Component.text((String)owner.getName()));
        ItemStack item = event.getItem();
        item.setAmount(item.getAmount() - 1);
        Bukkit.getOnlinePlayers().forEach(p -> {
            p.hidePlayer(this.plugin, player);
            p.showPlayer(this.plugin, player);
        });
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            if (player.isOnline() && !Objects.equals(player.getPlayerProfile().getName(), playerName)) {
                player.setPlayerProfile(Bukkit.createProfile((UUID)playerUUID, (String)playerName));
                player.displayName((Component)Component.text((String)playerName));
                player.playerListName((Component)Component.text((String)playerName));
                for (ProfileProperty property : returnProfile.getProperties()) {
                    if (!"textures".equals(property.getName())) continue;
                    profile.setProperty(property);
                }
                Bukkit.getOnlinePlayers().forEach(p -> {
                    p.hidePlayer(this.plugin, player);
                    p.showPlayer(this.plugin, player);
                });
            }
        }, 20L * (long)this.config.getInt("disguiseDuration"));
    }
}

