/*
 * Decompiled with CFR 0.152.
 */
package at.acpi.heartfall;

import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class AbsorbableHealthEntity
extends class_1297 {
    private static final class_2940<Float> DATA_HEAL = class_2945.method_12791(AbsorbableHealthEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> DATA_DEATH_TICKS = class_2945.method_12791(AbsorbableHealthEntity.class, (class_2941)class_2943.field_13327);
    private static final float MIN_HEAL = 1.5f;
    private static final float MAX_HEAL = 7.5f;
    private static final double PICKUP_RANGE = 1.4;
    private static final double ATTRACTION_RANGE = 5.0;
    private static final double ATTRACTION_SPEED = 0.1;
    private static final double GRAVITY = 0.075;
    private static final double DAMPING = 0.9;
    private static final double ATTRACTION_BLEND = 0.25;
    private static final double MOTION_DAMP = 0.75;
    private static final int DEATH_ANIMATION_TICKS = 10;
    private static final int LIFESPAN_TICKS = 320;
    private double spawnY;

    public AbsorbableHealthEntity(class_1299<? extends AbsorbableHealthEntity> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_HEAL, (Object)Float.valueOf(1.5f + this.field_5974.method_43057() * 6.0f));
        builder.method_56912(DATA_DEATH_TICKS, (Object)0);
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.field_6008 = 0;
        double vx = (this.field_5974.method_43058() - 0.5) * 0.2;
        double vy = 0.175 + this.field_5974.method_43058() * 0.25;
        double vz = (this.field_5974.method_43058() - 0.5) * 0.2;
        this.method_18800(vx, vy, vz);
        this.spawnY = this.method_23318();
    }

    public float getHeal() {
        return ((Float)this.method_5841().method_12789(DATA_HEAL)).floatValue();
    }

    public void setHeal(float life) {
        this.method_5841().method_12778(DATA_HEAL, (Object)Float.valueOf(life));
    }

    public int getDeathTicks() {
        return (Integer)this.method_5841().method_12789(DATA_DEATH_TICKS);
    }

    public void setDeathTicks(int ticks) {
        this.method_5841().method_12778(DATA_DEATH_TICKS, (Object)ticks);
    }

    public boolean isDying() {
        return this.getDeathTicks() > 0;
    }

    public float getDeathProgress(float partialTicks) {
        if (!this.isDying()) {
            return 0.0f;
        }
        return 1.0f - ((float)this.getDeathTicks() + partialTicks) / 10.0f;
    }

    public boolean method_64397(class_3218 serverLevel, class_1282 damageSource, float f) {
        return false;
    }

    public boolean method_5655() {
        return true;
    }

    protected void method_5749(class_11368 tag) {
        this.setHeal(tag.method_71423("heal", 3.0f));
        this.setDeathTicks(tag.method_71424("deathTicks", 0));
    }

    protected void method_5652(class_11372 tag) {
        tag.method_71464("heal", this.getHeal());
        tag.method_71465("deathTicks", this.getDeathTicks());
    }

    public void method_5773() {
        super.method_5773();
        if (this.handleDeathAnimation()) {
            return;
        }
        if (this.handleLifespan()) {
            return;
        }
        class_1657 player = this.method_73183().method_18460((class_1297)this, 5.0);
        class_243 motion = this.method_18798();
        if (player == null || this.cannotAttractTo(player)) {
            motion = this.inhibitGravityIfAirborne(motion);
        } else {
            if (this.attemptPickup(player)) {
                return;
            }
            motion = this.attractTowards(motion, player);
        }
        this.method_18799(motion);
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_18799(this.method_18798().method_18805(0.9, 1.0, 0.9));
    }

    private boolean handleDeathAnimation() {
        if (!this.isDying()) {
            return false;
        }
        int ticks = this.getDeathTicks() - 1;
        this.setDeathTicks(ticks);
        if (ticks <= 0) {
            this.method_31472();
        }
        return true;
    }

    private boolean handleLifespan() {
        if (this.field_6012 < 320) {
            return false;
        }
        this.setDeathTicks(10);
        return true;
    }

    private boolean cannotAttractTo(class_1657 player) {
        return player.method_7325() || !player.method_68878() && !(player.method_6032() < player.method_6063());
    }

    private class_243 inhibitGravityIfAirborne(class_243 motion) {
        this.method_5875(false);
        motion = motion.method_1023(0.0, 0.075, 0.0);
        if (this.method_23318() <= this.spawnY) {
            motion = new class_243(motion.field_1352, -motion.field_1351 * 0.6, motion.field_1350);
            this.method_5814(this.method_23317(), this.spawnY, this.method_23321());
        }
        return motion;
    }

    private class_243 attractTowards(class_243 motion, class_1657 player) {
        class_243 target = player.method_73189().method_1031(0.0, (double)player.method_17682() / 2.75, 0.0);
        class_243 toPlayer = target.method_1020(this.method_73189());
        double distance = toPlayer.method_1033();
        double speed = 1.0 + (5.0 - distance) / 5.0 * 3.0;
        class_243 attraction = toPlayer.method_1029().method_1021(0.1 * speed);
        this.method_5875(true);
        return motion.method_1021(0.75).method_1019(attraction.method_1021(0.25));
    }

    private boolean attemptPickup(class_1657 player) {
        if (!this.method_73183().method_8608() && (double)this.method_5739((class_1297)player) < 1.4) {
            this.tryPickup(player);
            return true;
        }
        return false;
    }

    private void tryPickup(class_1657 player) {
        if (this.cannotAttractTo(player)) {
            return;
        }
        float hp = Math.min(player.method_6032() + this.getHeal(), player.method_6063());
        player.method_6033(hp);
        float pitch = 1.25f + this.field_5974.method_43057() * 0.5f;
        player.method_73183().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 1.0f, pitch);
        this.setDeathTicks(10);
    }
}

