/*
 * Decompiled with CFR 0.152.
 */
package at.acpi.heartfall.client;

import at.acpi.heartfall.AbsorbableHealthEntity;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class AbsorbableHealthEntityRenderer
extends class_897<AbsorbableHealthEntity, AbsorbableHealthEntityRenderState> {
    private static final class_2960 CONTAINER = class_2960.method_60656((String)"textures/gui/sprites/hud/heart/container.png");
    private static final class_2960 HEART_FULL = class_2960.method_60656((String)"textures/gui/sprites/hud/heart/full.png");
    private static final class_1921 CONTAINER_LAYER = class_1921.method_29379((class_2960)CONTAINER);
    private static final class_1921 HEART_LAYER = class_1921.method_29379((class_2960)HEART_FULL);

    public AbsorbableHealthEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    private static void produceVertex(class_4588 consumer, class_4587.class_4665 pose, float x, float y, float z, int alpha, float u, float v) {
        consumer.method_56824(pose, x, y, z).method_1336(255, 255, 255, alpha).method_22913(u, v).method_22922(0).method_60803(0xF000F0).method_60831(pose, 0.0f, 1.0f, 0.0f);
    }

    @NotNull
    public AbsorbableHealthEntityRenderState createRenderState() {
        return new AbsorbableHealthEntityRenderState();
    }

    public void extractRenderState(AbsorbableHealthEntity entity, AbsorbableHealthEntityRenderState state, float partialTicks) {
        super.method_62354((class_1297)entity, (class_10017)state, partialTicks);
        float delta = (float)entity.field_6012 + partialTicks;
        float bob = (float)Math.sin((double)delta / 10.0 + 0.5) * 0.1f;
        float deathProgress = entity.getDeathProgress(partialTicks);
        state.rotation = delta / 20.0f;
        state.scale = 0.5f + deathProgress * 0.75f;
        state.bob = 0.5f + bob;
        float pulse = 0.75f + (float)Math.sin(delta * 0.25f) * 0.1f;
        float ageFade = 1.0f - (float)Math.max(0, entity.field_6012 - 220) / 100.0f;
        state.alpha = (int)(pulse * ageFade * (1.0f - deathProgress) * 255.0f);
    }

    public void submit(AbsorbableHealthEntityRenderState state, class_4587 stack, class_11659 collector, class_12075 camera) {
        stack.method_22903();
        stack.method_46416(0.0f, state.bob, 0.0f);
        stack.method_22905(state.scale, state.scale, state.scale);
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.rotation));
        this.drawQuad(stack, collector, HEART_LAYER, state.alpha, 0.0f);
        this.drawQuad(stack, collector, CONTAINER_LAYER, state.alpha, -0.001f);
        this.drawQuad(stack, collector, HEART_LAYER, state.alpha, -0.002f);
        stack.method_22909();
        super.method_3936((class_10017)state, stack, collector, camera);
    }

    private void drawQuad(class_4587 matrices, class_11659 collector, class_1921 layer, int alpha, float zOffset) {
        collector.method_73483(matrices, layer, (pose, consumer) -> {
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, -0.5f, zOffset, alpha, 0.0f, 1.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, -0.5f, zOffset, alpha, 1.0f, 1.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, 0.5f, zOffset, alpha, 1.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, 0.5f, zOffset, alpha, 0.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, 0.5f, zOffset, alpha, 0.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, 0.5f, zOffset, alpha, 1.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, -0.5f, zOffset, alpha, 1.0f, 1.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, -0.5f, zOffset, alpha, 0.0f, 1.0f);
        });
    }

    public static class AbsorbableHealthEntityRenderState
    extends class_10017 {
        public float scale;
        public float rotation;
        public float bob;
        public int alpha;
    }
}

