/*
 * Decompiled with CFR 0.152.
 */
package at.acpi.heartfall;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class AbsorbableHealthEntity
extends Entity {
    public static final float MIN_HEAL = 1.5f;
    public static final float MAX_HEAL = 5.0f;
    public static final double PICKUP_RANGE = 1.25;
    public static final double ATTRACTION_RANGE = 5.0;
    public static final double ATTRACTION_SPEED = 0.1;
    private static final EntityDataAccessor<Float> DATA_HEAL = SynchedEntityData.defineId(AbsorbableHealthEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_DEATH_TICKS = SynchedEntityData.defineId(AbsorbableHealthEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final double GRAVITY = 0.075;
    private static final double DAMPING = 0.9;
    private static final double ATTRACTION_BLEND = 0.25;
    private static final double MOTION_DAMP = 0.75;
    private static final int DEATH_ANIMATION_TICKS = 10;
    private static final int LIFESPAN_TICKS = 320;
    private double spawnY;

    public AbsorbableHealthEntity(EntityType<? extends AbsorbableHealthEntity> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_HEAL, (Object)Float.valueOf(1.5f + this.random.nextFloat() * 3.5f));
        builder.define(DATA_DEATH_TICKS, (Object)0);
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.invulnerableTime = 0;
        double vx = (this.random.nextDouble() - 0.5) * 0.2;
        double vy = 0.175 + this.random.nextDouble() * 0.25;
        double vz = (this.random.nextDouble() - 0.5) * 0.2;
        this.setDeltaMovement(vx, vy, vz);
        this.spawnY = this.getY();
    }

    public float getHeal() {
        return ((Float)this.getEntityData().get(DATA_HEAL)).floatValue();
    }

    public void setHeal(float life) {
        this.getEntityData().set(DATA_HEAL, (Object)Float.valueOf(life));
    }

    public int getDeathTicks() {
        return (Integer)this.getEntityData().get(DATA_DEATH_TICKS);
    }

    public void setDeathTicks(int ticks) {
        this.getEntityData().set(DATA_DEATH_TICKS, (Object)ticks);
    }

    public boolean isDying() {
        return this.getDeathTicks() > 0;
    }

    public float getDeathProgress(float partialTicks) {
        if (!this.isDying()) {
            return 0.0f;
        }
        return 1.0f - ((float)this.getDeathTicks() + partialTicks) / 10.0f;
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float f) {
        return false;
    }

    public boolean isInvulnerable() {
        return true;
    }

    protected void readAdditionalSaveData(ValueInput tag) {
        this.setHeal(tag.getFloatOr("heal", 3.0f));
        this.setDeathTicks(tag.getIntOr("deathTicks", 0));
    }

    protected void addAdditionalSaveData(ValueOutput tag) {
        tag.putFloat("heal", this.getHeal());
        tag.putInt("deathTicks", this.getDeathTicks());
    }

    public void tick() {
        super.tick();
        if (this.handleDeathAnimation()) {
            return;
        }
        if (this.handleLifespan()) {
            return;
        }
        Player player = this.level().getNearestPlayer((Entity)this, 5.0);
        Vec3 motion = this.getDeltaMovement();
        if (player == null || this.cannotAttractTo(player)) {
            motion = this.inhibitGravityIfAirborne(motion);
        } else {
            if (this.attemptPickup(player)) {
                return;
            }
            motion = this.attractTowards(motion, player);
        }
        this.setDeltaMovement(motion);
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
    }

    private boolean handleDeathAnimation() {
        if (!this.isDying()) {
            return false;
        }
        int ticks = this.getDeathTicks() - 1;
        this.setDeathTicks(ticks);
        Player nearest = this.level().getNearestPlayer((Entity)this, 5.0);
        if (nearest != null) {
            double progress = 1.0 - (double)ticks / 10.0;
            Vec3 current = this.position();
            Vec3 target = nearest.position().add(0.0, (double)nearest.getBbHeight() * 0.25, 0.0);
            this.setPos(current.x * (1.0 - progress) + target.x * progress, current.y * (1.0 - progress) + target.y * progress, current.z * (1.0 - progress) + target.z * progress);
        }
        if (ticks <= 0) {
            this.discard();
        }
        return true;
    }

    private boolean handleLifespan() {
        if (this.tickCount < 320) {
            return false;
        }
        this.setDeathTicks(10);
        return true;
    }

    private boolean cannotAttractTo(Player player) {
        return player.isSpectator() || !player.isCreative() && !(player.getHealth() < player.getMaxHealth());
    }

    private Vec3 inhibitGravityIfAirborne(Vec3 motion) {
        this.setNoGravity(false);
        motion = motion.subtract(0.0, 0.075, 0.0);
        if (this.getY() <= this.spawnY) {
            motion = new Vec3(motion.x, -motion.y * 0.6, motion.z);
            this.setPos(this.getX(), this.spawnY, this.getZ());
        }
        return motion;
    }

    private Vec3 attractTowards(Vec3 motion, Player player) {
        Vec3 target = player.position().add(0.0, (double)player.getBbHeight() * 0.25, 0.0);
        Vec3 toPlayer = target.subtract(this.position());
        double distance = toPlayer.length();
        double speed = 1.0 + (5.0 - distance) / 5.0 * 3.0;
        Vec3 attraction = toPlayer.normalize().scale(0.1 * speed);
        this.setNoGravity(true);
        return motion.scale(0.75).add(attraction.scale(0.25));
    }

    private boolean attemptPickup(Player player) {
        if (!this.level().isClientSide() && (double)this.distanceTo((Entity)player) < 1.25) {
            this.tryPickup(player);
            return true;
        }
        return false;
    }

    private void tryPickup(Player player) {
        if (this.cannotAttractTo(player)) {
            return;
        }
        float hp = Math.min(player.getHealth() + this.getHeal(), player.getMaxHealth());
        player.setHealth(hp);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BUBBLE_POP, SoundSource.PLAYERS, 10.0f, 1.0f);
        this.setDeathTicks(10);
    }
}

