/*
 * Decompiled with CFR 0.152.
 */
package at.acpi.heartfall.client;

import at.acpi.heartfall.AbsorbableHealthEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

public class AbsorbableHealthEntityRenderer
extends EntityRenderer<AbsorbableHealthEntity, AbsorbableHealthEntityRenderState> {
    private static final ResourceLocation CONTAINER = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/container.png");
    private static final ResourceLocation HEART_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/full.png");
    private static final RenderType CONTAINER_LAYER = RenderType.itemEntityTranslucentCull((ResourceLocation)CONTAINER);
    private static final RenderType HEART_LAYER = RenderType.itemEntityTranslucentCull((ResourceLocation)HEART_FULL);

    public AbsorbableHealthEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    private static void produceVertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int alpha, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(255, 255, 255, alpha).setUv(u, v).setOverlay(0).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    @NotNull
    public AbsorbableHealthEntityRenderState createRenderState() {
        return new AbsorbableHealthEntityRenderState();
    }

    public void extractRenderState(AbsorbableHealthEntity entity, AbsorbableHealthEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        float delta = (float)entity.tickCount + partialTicks;
        float bob = (float)Math.sin((double)delta / 10.0 + 0.5) * 0.1f;
        float deathProgress = entity.getDeathProgress(partialTicks);
        state.rotation = delta / 20.0f;
        state.scale = 0.5f + (float)Math.sin(delta * 0.25f) * 0.05f;
        state.bob = 0.5f + bob;
        float pulse = 0.75f + (float)Math.sin(delta * 0.25f) * 0.1f;
        float ageFade = 1.0f - (float)Math.max(0, entity.tickCount - 220) / 100.0f;
        state.alpha = (int)(pulse * ageFade * (1.0f - deathProgress) * 225.0f);
    }

    public void submit(AbsorbableHealthEntityRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState camera) {
        stack.pushPose();
        stack.translate(0.0f, state.bob, 0.0f);
        stack.scale(state.scale, state.scale, state.scale);
        stack.mulPose((Quaternionfc)Axis.YP.rotation(state.rotation));
        this.drawQuad(stack, collector, HEART_LAYER, state.alpha, 0.0f);
        this.drawQuad(stack, collector, CONTAINER_LAYER, state.alpha, -0.001f);
        this.drawQuad(stack, collector, HEART_LAYER, state.alpha, -0.002f);
        stack.popPose();
        super.submit((EntityRenderState)state, stack, collector, camera);
    }

    private void drawQuad(PoseStack matrices, SubmitNodeCollector collector, RenderType layer, int alpha, float zOffset) {
        collector.submitCustomGeometry(matrices, layer, (pose, consumer) -> {
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, -0.5f, zOffset, alpha, 0.0f, 1.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, -0.5f, zOffset, alpha, 1.0f, 1.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, 0.5f, zOffset, alpha, 1.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, 0.5f, zOffset, alpha, 0.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, 0.5f, zOffset, alpha, 0.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, 0.5f, zOffset, alpha, 1.0f, 0.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, 0.5f, -0.5f, zOffset, alpha, 1.0f, 1.0f);
            AbsorbableHealthEntityRenderer.produceVertex(consumer, pose, -0.5f, -0.5f, zOffset, alpha, 0.0f, 1.0f);
        });
    }

    public static class AbsorbableHealthEntityRenderState
    extends EntityRenderState {
        public float scale;
        public float rotation;
        public float bob;
        public int alpha;
    }
}

