/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.item;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.xstopho.resource_cracker.config.LootConfig;
import net.xstopho.resource_cracker.item.components.TooltipContainer;
import net.xstopho.resource_cracker.registries.DataComponentRegistry;
import net.xstopho.resource_cracker.registries.ItemRegistry;
import org.jetbrains.annotations.NotNull;

public class ChiselItem
extends Item {
    public static final Random rnd = new Random();
    private final Supplier<Integer> durability;
    private final Supplier<Float> saltpeterChance;

    public ChiselItem(Supplier<Integer> durability, Item.Properties properties) {
        super(properties.component((DataComponentType)DataComponentRegistry.TOOLTIP_CONTAINER.get(), (Object)new TooltipContainer(List.of(Component.translatable((String)"item.chisel.tooltip").withStyle(ChatFormatting.GOLD)))));
        this.durability = durability;
        this.saltpeterChance = () -> Float.valueOf(LootConfig.saltpeterFromBricks);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        Block block = context.getLevel().getBlockState(context.getClickedPos()).getBlock();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        if (block.equals(Blocks.BRICKS) && rnd.nextFloat() <= this.saltpeterChance.get().floatValue()) {
            Containers.dropItemStack((Level)context.getLevel(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)ItemRegistry.MATERIAL_DUST_SALTPETER.get()));
        }
        context.getItemInHand().hurtAndBreak(1, (LivingEntity)context.getPlayer(), EquipmentSlot.MAINHAND);
        return InteractionResult.SUCCESS;
    }

    public int getDurability() {
        return this.durability.get();
    }

    public ItemStack addDurability(ItemStack stack) {
        ItemStack copy = stack.copy();
        copy.set(DataComponents.MAX_DAMAGE, (Object)this.durability.get());
        copy.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        copy.set(DataComponents.DAMAGE, (Object)0);
        return copy;
    }
}

