/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.item.materials;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.level.block.Blocks;
import net.xstopho.resource_cracker.CrackerConstants;
import net.xstopho.resource_cracker.item.tags.CrackerItemTags;

public record ScytheMaterial(int durability, float damageBonus, int enchantmentValue, TagKey<Item> repairItem) {
    private static final ResourceLocation EXTENDED_ENTITY_REACH_ID = CrackerConstants.of("extended_entity_reach");
    private static final ResourceLocation EXTENDED_BLOCK_REACH_ID = CrackerConstants.of("extended_block_reach");
    public static final ScytheMaterial COPPER = new ScytheMaterial(100, 0.0f, 5, CrackerItemTags.COPPER_TOOL_MATERIALS);
    public static final ScytheMaterial GOLD = new ScytheMaterial(32, 0.0f, 22, (TagKey<Item>)ItemTags.GOLD_TOOL_MATERIALS);
    public static final ScytheMaterial IRON = new ScytheMaterial(250, 0.0f, 15, (TagKey<Item>)ItemTags.IRON_TOOL_MATERIALS);
    public static final ScytheMaterial STEEL = new ScytheMaterial(450, 1.5f, 13, CrackerItemTags.STEEL_TOOL_MATERIALS);
    public static final ScytheMaterial DIAMOND = new ScytheMaterial(1561, 3.0f, 10, (TagKey<Item>)ItemTags.DIAMOND_TOOL_MATERIALS);
    public static final ScytheMaterial NETHERITE = new ScytheMaterial(2031, 4.0f, 15, (TagKey<Item>)ItemTags.NETHERITE_TOOL_MATERIALS);

    private Item.Properties applyCommonProperties(Item.Properties properties) {
        return properties.durability(this.durability()).repairable(this.repairItem()).enchantable(this.enchantmentValue());
    }

    public Item.Properties applyScytheProperties(Item.Properties properties, float baseDamage, float baseSpeed) {
        HolderGetter getter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((HolderSet)HolderSet.direct((Holder[])new Holder[]{Blocks.COBWEB.builtInRegistryHolder()}), (float)15.0f), Tool.Rule.overrideSpeed((HolderSet)getter.getOrThrow(BlockTags.SWORD_INSTANTLY_MINES), (float)Float.MAX_VALUE), Tool.Rule.overrideSpeed((HolderSet)getter.getOrThrow(BlockTags.SWORD_EFFICIENT), (float)1.5f)), 1.0f, 2, false)).attributes(this.createScytheAttributes(baseDamage, baseSpeed)).component(DataComponents.WEAPON, (Object)new Weapon(1));
    }

    private ItemAttributeModifiers createScytheAttributes(float baseDamage, float baseSpeed) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(baseDamage + this.damageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)baseSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(EXTENDED_ENTITY_REACH_ID, 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(EXTENDED_BLOCK_REACH_ID, 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

