/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.registries;

import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.xstopho.resource_cracker.block.GarlicCropBlock;
import net.xstopho.resource_cracker.block.LavaSpringBlock;
import net.xstopho.resource_cracker.block.WaterSpringBlock;
import net.xstopho.resource_cracker.registries.ItemRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class BlockRegistry {
    public static final RegistryProvider<Block> BLOCKS = RegistryProvider.get((String)"resource_cracker", (Registry)BuiltInRegistries.BLOCK);
    public static final RegistryObject<Block> GARLIC_CROP = BlockRegistry.registerWithoutItem("garlic_crop", GarlicCropBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTATOES));
    public static final RegistryObject<Block> WATER_SPRING_BLOCK = BlockRegistry.register("water_spring_block", WaterSpringBlock::new);
    public static final RegistryObject<Block> LAVA_SPRING_BLOCK = BlockRegistry.register("lava_spring_block", LavaSpringBlock::new);
    public static final RegistryObject<Block> STEEL_BLOCK = BlockRegistry.register("steel_block", Block::new);

    private static RegistryObject<Block> register(String id, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockBehavior) {
        RegistryObject toReturn = BLOCKS.register(id, () -> (Block)function.apply(blockBehavior.setId(BlockRegistry.createKey(id))));
        ItemRegistry.register(id, (Item.Properties properties) -> new BlockItem((Block)toReturn.get(), properties.useBlockDescriptionPrefix()));
        return toReturn;
    }

    private static RegistryObject<Block> registerWithoutItem(String id, Function<BlockBehaviour.Properties, Block> function, BlockBehaviour.Properties blockBehavior) {
        return BLOCKS.register(id, () -> (Block)function.apply(blockBehavior.setId(BlockRegistry.createKey(id))));
    }

    private static RegistryObject<Block> register(String id, Function<BlockBehaviour.Properties, Block> function) {
        return BlockRegistry.register(id, function, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK));
    }

    private static ResourceKey<Block> createKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)BLOCKS.getModId(), (String)id));
    }

    public static void init() {
    }
}

