/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker;

import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resource_cracker.config.LootConfig;
import net.xstopho.resource_cracker.config.ToolConfig;
import net.xstopho.resource_cracker.item.ChiselItem;
import net.xstopho.resource_cracker.item.CrackHammerItem;
import net.xstopho.resource_cracker.modifier.LootModifier;
import net.xstopho.resource_cracker.registries.BlockRegistry;
import net.xstopho.resource_cracker.registries.CreativeTabRegistry;
import net.xstopho.resource_cracker.registries.DataComponentRegistry;
import net.xstopho.resource_cracker.registries.ItemRegistry;
import net.xstopho.resourceconfigapi.api.ConfigRegistry;
import net.xstopho.resourcelibrary.event.LootTableModifierCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrackerConstants {
    public static final String MOD_ID = "resource_cracker";
    public static final String MOD_NAME = "Resource Cracker/Tools";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Resource Cracker/Tools");

    public static ResourceLocation of(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }

    public static void commonInit() {
        ConfigRegistry.register(ToolConfig.class, (String)MOD_ID);
        ConfigRegistry.register(LootConfig.class, (String)MOD_ID);
        DataComponentRegistry.init();
        BlockRegistry.init();
        ItemRegistry.init();
        CreativeTabRegistry.init();
        LootModifier.init();
        LootTableModifierCallback.MODIFY.register(itemStack -> {
            Item patt1$temp;
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof CrackHammerItem) {
                CrackHammerItem hammer = (CrackHammerItem)patt0$temp;
                CrackerConstants.addDurability(itemStack, hammer.getDurability());
            }
            if ((patt1$temp = itemStack.getItem()) instanceof ChiselItem) {
                ChiselItem chisel = (ChiselItem)patt1$temp;
                CrackerConstants.addDurability(itemStack, chisel.getDurability());
            }
        });
    }

    private static void addDurability(ItemStack stack, int durability) {
        stack.set(DataComponents.MAX_DAMAGE, (Object)durability);
        stack.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        stack.set(DataComponents.DAMAGE, (Object)0);
    }
}

