/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.xstopho.resource_cracker.item.components.TooltipContainer;
import net.xstopho.resource_cracker.registries.DataComponentRegistry;
import net.xstopho.resourcelibrary.item.ResourceCraftingRemainder;

public class CrackHammerItem
extends ResourceCraftingRemainder {
    private final Supplier<Integer> durability;

    public CrackHammerItem(Supplier<Integer> durability, Item.Properties properties) {
        super(properties.component((DataComponentType)DataComponentRegistry.TOOLTIP_CONTAINER.get(), (Object)new TooltipContainer(List.of(Component.translatable((String)"item.crack_hammer.tooltip").withStyle(ChatFormatting.GOLD)))));
        this.durability = durability;
    }

    public ItemStack getRemainingItem(ItemStack itemStack) {
        if (itemStack.getDamageValue() < itemStack.getMaxDamage() - 1) {
            ItemStack damaged = itemStack.copy();
            damaged.setDamageValue(itemStack.getDamageValue() + 1);
            return damaged;
        }
        return ItemStack.EMPTY;
    }

    public int getDurability() {
        return this.durability.get();
    }

    public ItemStack addDurability(ItemStack stack) {
        ItemStack copy = stack.copy();
        copy.set(DataComponents.MAX_DAMAGE, (Object)this.durability.get());
        copy.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        copy.set(DataComponents.DAMAGE, (Object)0);
        return copy;
    }
}

