/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.xstopho.resource_cracker.config.ToolConfig;
import net.xstopho.resource_cracker.item.components.TooltipContainer;
import net.xstopho.resource_cracker.item.materials.ScytheMaterial;
import net.xstopho.resource_cracker.registries.DataComponentRegistry;

public class ScytheItem
extends Item {
    private static final Supplier<Integer> radius = () -> ToolConfig.scytheHarvestRadius;

    public ScytheItem(ScytheMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material.applyScytheProperties(properties, attackDamage, attackSpeed).component((DataComponentType)DataComponentRegistry.TOOLTIP_CONTAINER.get(), (Object)new TooltipContainer(List.of(Component.translatable((String)"item.scythe.tooltip").withStyle(ChatFormatting.GOLD), Component.translatable((String)"item.scythe.tooltip.radius").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(radius.get())).withStyle(ChatFormatting.RED))))));
    }

    public InteractionResult useOn(UseOnContext context) {
        CropBlock clickedCrop;
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player.isSpectator() || player.isCreative()) {
            return InteractionResult.PASS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = context.getLevel().getBlockState(clickedPos);
        Block block = clickedState.getBlock();
        if (block instanceof CropBlock && (clickedCrop = (CropBlock)block).isMaxAge(clickedState)) {
            for (int x = -radius.get().intValue(); x <= radius.get(); ++x) {
                for (int z = -radius.get().intValue(); z <= radius.get(); ++z) {
                    CropBlock replantCrop;
                    BlockPos crop = clickedPos.offset(x, 0, z);
                    BlockState cropState = context.getLevel().getBlockState(crop);
                    Block block2 = cropState.getBlock();
                    if (!(block2 instanceof CropBlock) || !(replantCrop = (CropBlock)block2).isMaxAge(cropState)) continue;
                    context.getLevel().destroyBlock(crop, true, (Entity)player);
                    context.getLevel().setBlockAndUpdate(crop, replantCrop.getStateForAge(0));
                }
            }
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }
}

