/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.registries;

import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.xstopho.resource_cracker.config.ToolConfig;
import net.xstopho.resource_cracker.item.ChiselItem;
import net.xstopho.resource_cracker.item.CrackHammerItem;
import net.xstopho.resource_cracker.item.ScytheItem;
import net.xstopho.resource_cracker.item.food.CrackerFoodProperties;
import net.xstopho.resource_cracker.item.materials.ScytheMaterial;
import net.xstopho.resource_cracker.registries.BlockRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class ItemRegistry {
    public static final RegistryProvider<Item> ITEMS = RegistryProvider.get((String)"resource_cracker", (Registry)BuiltInRegistries.ITEM);
    public static final RegistryObject<Item> MATERIAL_DUST_COPPER = ItemRegistry.register("material_dust_copper");
    public static final RegistryObject<Item> MATERIAL_DUST_IRON = ItemRegistry.register("material_dust_iron");
    public static final RegistryObject<Item> MATERIAL_DUST_GOLD = ItemRegistry.register("material_dust_gold");
    public static final RegistryObject<Item> MATERIAL_DUST_EMERALD = ItemRegistry.register("material_dust_emerald");
    public static final RegistryObject<Item> MATERIAL_DUST_DIAMOND = ItemRegistry.register("material_dust_diamond");
    public static final RegistryObject<Item> MATERIAL_DUST_NETHERITE_SCRAP = ItemRegistry.register("material_dust_netherite_scrap");
    public static final RegistryObject<Item> MATERIAL_DUST_NETHERITE = ItemRegistry.register("material_dust_netherite");
    public static final RegistryObject<Item> MATERIAL_DUST_CARBON = ItemRegistry.register("material_dust_carbon");
    public static final RegistryObject<Item> MATERIAL_DUST_STEEL = ItemRegistry.register("material_dust_steel");
    public static final RegistryObject<Item> MATERIAL_DUST_SULFUR = ItemRegistry.register("material_dust_sulfur");
    public static final RegistryObject<Item> MATERIAL_DUST_SALTPETER = ItemRegistry.register("material_dust_saltpeter");
    public static final RegistryObject<Item> STEEL_INGOT = ItemRegistry.register("steel_ingot");
    public static final RegistryObject<Item> NUGGET_DIAMOND = ItemRegistry.register("nugget_diamond");
    public static final RegistryObject<Item> NUGGET_EMERALD = ItemRegistry.register("nugget_emerald");
    public static final RegistryObject<Item> NUGGET_COPPER = ItemRegistry.register("nugget_copper");
    public static final RegistryObject<Item> CRACK_HAMMER_COPPER = ItemRegistry.register("crack_hammer_copper", properties -> new CrackHammerItem(() -> ToolConfig.copperHammer, (Item.Properties)properties));
    public static final RegistryObject<Item> CRACK_HAMMER_GOLD = ItemRegistry.register("crack_hammer_gold", properties -> new CrackHammerItem(() -> ToolConfig.goldHammer, (Item.Properties)properties));
    public static final RegistryObject<Item> CRACK_HAMMER_IRON = ItemRegistry.register("crack_hammer_iron", properties -> new CrackHammerItem(() -> ToolConfig.ironHammer, (Item.Properties)properties));
    public static final RegistryObject<Item> CRACK_HAMMER_STEEL = ItemRegistry.register("crack_hammer_steel", properties -> new CrackHammerItem(() -> ToolConfig.steelHammer, (Item.Properties)properties));
    public static final RegistryObject<Item> CRACK_HAMMER_DIAMOND = ItemRegistry.register("crack_hammer_diamond", properties -> new CrackHammerItem(() -> ToolConfig.diamondHammer, (Item.Properties)properties));
    public static final RegistryObject<Item> CRACK_HAMMER_NETHERITE = ItemRegistry.register("crack_hammer_netherite", properties -> new CrackHammerItem(() -> ToolConfig.netheriteHammer, properties.fireResistant()));
    public static final RegistryObject<Item> CHISEL_COPPER = ItemRegistry.register("chisel_copper", properties -> new ChiselItem(() -> ToolConfig.copperChisel, (Item.Properties)properties));
    public static final RegistryObject<Item> CHISEL_GOLD = ItemRegistry.register("chisel_gold", properties -> new ChiselItem(() -> ToolConfig.goldChisel, (Item.Properties)properties));
    public static final RegistryObject<Item> CHISEL_IRON = ItemRegistry.register("chisel_iron", properties -> new ChiselItem(() -> ToolConfig.ironChisel, (Item.Properties)properties));
    public static final RegistryObject<Item> CHISEL_STEEL = ItemRegistry.register("chisel_steel", properties -> new ChiselItem(() -> ToolConfig.steelChisel, (Item.Properties)properties));
    public static final RegistryObject<Item> CHISEL_DIAMOND = ItemRegistry.register("chisel_diamond", properties -> new ChiselItem(() -> ToolConfig.diamondChisel, (Item.Properties)properties));
    public static final RegistryObject<Item> CHISEL_NETHERITE = ItemRegistry.register("chisel_netherite", properties -> new ChiselItem(() -> ToolConfig.netheriteChisel, properties.fireResistant()));
    public static final RegistryObject<Item> SCYTHE_COPPER = ItemRegistry.register("scythe_copper", properties -> new ScytheItem(ScytheMaterial.COPPER, 2.0f, -1.8f, (Item.Properties)properties));
    public static final RegistryObject<Item> SCYTHE_GOLD = ItemRegistry.register("scythe_gold", properties -> new ScytheItem(ScytheMaterial.GOLD, 3.0f, -1.8f, (Item.Properties)properties));
    public static final RegistryObject<Item> SCYTHE_IRON = ItemRegistry.register("scythe_iron", properties -> new ScytheItem(ScytheMaterial.IRON, 3.0f, -1.8f, (Item.Properties)properties));
    public static final RegistryObject<Item> SCYTHE_STEEL = ItemRegistry.register("scythe_steel", properties -> new ScytheItem(ScytheMaterial.STEEL, 3.0f, -1.8f, (Item.Properties)properties));
    public static final RegistryObject<Item> SCYTHE_DIAMOND = ItemRegistry.register("scythe_diamond", properties -> new ScytheItem(ScytheMaterial.DIAMOND, 4.0f, -1.8f, (Item.Properties)properties));
    public static final RegistryObject<Item> SCYTHE_NETHERITE = ItemRegistry.register("scythe_netherite", properties -> new ScytheItem(ScytheMaterial.NETHERITE, 5.0f, -1.8f, properties.fireResistant()));
    public static final RegistryObject<Item> GARLIC = ItemRegistry.register("garlic", properties -> new BlockItem((Block)BlockRegistry.GARLIC_CROP.get(), properties.food(CrackerFoodProperties.GARLIC)));
    public static final RegistryObject<Item> BEEF_JERKY = ItemRegistry.register("beef_jerky", properties -> new Item(properties.food(CrackerFoodProperties.BEEF_JERKY)));

    public static RegistryObject<Item> register(String id, Function<Item.Properties, Item> function, Item.Properties properties) {
        return ITEMS.register(id, () -> (Item)function.apply(properties.setId(ItemRegistry.createKey(id))));
    }

    public static RegistryObject<Item> register(String id, Function<Item.Properties, Item> function) {
        return ItemRegistry.register(id, function, new Item.Properties());
    }

    public static RegistryObject<Item> register(String id) {
        return ItemRegistry.register(id, Item::new);
    }

    private static ResourceKey<Item> createKey(String id) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ITEMS.getModId(), (String)id));
    }

    public static void init() {
    }
}

