/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.block.base;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SpringBlock
extends Block {
    public static final MapCodec<SpringBlock> CODEC = SpringBlock.simpleCodec(SpringBlock::new);

    public SpringBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static ItemInteractionResult addOrDropItem(Player player, ItemStack stack) {
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (handStack.getCount() == 1) {
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            return ItemInteractionResult.SUCCESS;
        }
        if (!player.getInventory().add(stack)) {
            player.drop(stack, false);
        }
        handStack.shrink(1);
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }
}

