/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.xstopho.resourcelibrary.items.RecipeRemainder;

public class CrackHammerItem
extends RecipeRemainder {
    private final Supplier<Integer> durability;

    public CrackHammerItem(Supplier<Integer> durability) {
        super(new Item.Properties());
        this.durability = durability;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public ItemStack getRemainingItem(ItemStack itemStack) {
        if (itemStack.getDamageValue() < itemStack.getMaxDamage() - 1) {
            ItemStack damaged = itemStack.copy();
            damaged.setDamageValue(itemStack.getDamageValue() + 1);
            return damaged;
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.crack_hammer.tooltip").withStyle(ChatFormatting.GOLD));
        super.appendHoverText(itemStack, tooltipContext, tooltip, tooltipFlag);
    }

    public int getDurability() {
        return this.durability.get();
    }

    public ItemStack addDurability() {
        ItemStack stack = this.getDefaultInstance();
        stack.set(DataComponents.MAX_DAMAGE, (Object)this.getDurability());
        stack.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        stack.set(DataComponents.DAMAGE, (Object)0);
        return stack;
    }
}

