/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.xstopho.resource_cracker.config.ToolConfig;

public class ScytheItem
extends SwordItem {
    public static final ResourceLocation BASE_ENTITY_REACH = ResourceLocation.fromNamespaceAndPath((String)"resource_cracker", (String)"base_entity_reach");
    public static final ResourceLocation BASE_BLOCK_REACH = ResourceLocation.fromNamespaceAndPath((String)"resource_cracker", (String)"base_block_reach");
    private final Supplier<Integer> radius = () -> ToolConfig.scytheHarvestRadius;

    public ScytheItem(Tier tier, int attackDamage, float attackSpeed) {
        super(tier, new Item.Properties().attributes(ScytheItem.createAttributes((Tier)tier, (int)attackDamage, (float)attackSpeed).withModifierAdded(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(BASE_BLOCK_REACH, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).withModifierAdded(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_ENTITY_REACH, 1.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)));
    }

    public InteractionResult useOn(UseOnContext context) {
        CropBlock clickedCrop;
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Player player = context.getPlayer();
        if (player.isSpectator() || player.isCreative()) {
            return InteractionResult.PASS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = context.getLevel().getBlockState(clickedPos);
        Block block = clickedState.getBlock();
        if (block instanceof CropBlock && (clickedCrop = (CropBlock)block).isMaxAge(clickedState)) {
            for (int x = -this.radius.get().intValue(); x <= this.radius.get(); ++x) {
                for (int z = -this.radius.get().intValue(); z <= this.radius.get(); ++z) {
                    CropBlock replantCrop;
                    BlockPos crop = clickedPos.offset(x, 0, z);
                    BlockState cropState = context.getLevel().getBlockState(crop);
                    Block block2 = cropState.getBlock();
                    if (!(block2 instanceof CropBlock) || !(replantCrop = (CropBlock)block2).isMaxAge(cropState)) continue;
                    context.getLevel().destroyBlock(crop, true, (Entity)player);
                    context.getLevel().setBlockAndUpdate(crop, replantCrop.getStateForAge(0));
                }
            }
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.scythe.tooltip").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"item.scythe.tooltip.radius").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)String.valueOf(this.radius.get())).withStyle(ChatFormatting.RED)));
        super.appendHoverText(itemStack, tooltipContext, tooltip, tooltipFlag);
    }
}

