/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.mixin;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.xstopho.resource_cracker.item.CrackHammerItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RepairItemRecipe.class})
public abstract class RepairItemRecipeMixin {
    @Shadow
    public abstract Pair<ItemStack, ItemStack> getItemsToCombine(CraftingInput var1);

    @Inject(method={"assemble"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(CraftingInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        Pair<ItemStack, ItemStack> pair = this.getItemsToCombine(input);
        if (this.isCrackHammer(pair)) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
        }
    }

    private boolean isCrackHammer(Pair<ItemStack, ItemStack> pair) {
        return ((ItemStack)pair.getFirst()).getItem() == ((ItemStack)pair.getSecond()).getItem() && ((ItemStack)pair.getFirst()).getItem() instanceof CrackHammerItem;
    }
}

