/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.mixin;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.xstopho.resource_cracker.item.ChiselItem;
import net.xstopho.resource_cracker.item.CrackHammerItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapedRecipe.class})
public abstract class ShapedRecipeMixin {
    @Shadow
    public abstract ItemStack getResultItem(HolderLookup.Provider var1);

    @Shadow
    public abstract NonNullList<Ingredient> getIngredients();

    @Inject(method={"assemble"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAssemble(CraftingInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = this.getResultItem(registries).copy();
        Item item = result.getItem();
        if (item instanceof ChiselItem) {
            ChiselItem chisel = (ChiselItem)item;
            cir.setReturnValue((Object)this.addDurability(result, chisel.getDurability()));
        }
        if ((item = result.getItem()) instanceof CrackHammerItem) {
            CrackHammerItem crackHammer = (CrackHammerItem)item;
            cir.setReturnValue((Object)this.addDurability(result, crackHammer.getDurability()));
        }
    }

    private ItemStack addDurability(ItemStack stack, int durability) {
        stack.set(DataComponents.MAX_DAMAGE, (Object)durability);
        stack.set(DataComponents.MAX_STACK_SIZE, (Object)1);
        stack.set(DataComponents.DAMAGE, (Object)0);
        return stack;
    }
}

