/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.registries;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.xstopho.resource_cracker.block.GarlicCropBlock;
import net.xstopho.resource_cracker.block.LavaSpringBlock;
import net.xstopho.resource_cracker.block.WaterSpringBlock;
import net.xstopho.resource_cracker.registries.ItemRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class BlockRegistry {
    public static final RegistryProvider<Block> BLOCKS = RegistryProvider.get((ResourceKey)Registries.BLOCK, (String)"resource_cracker");
    public static final RegistryObject<Block> GARLIC_CROP = BLOCKS.register("garlic_crop", () -> new GarlicCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTATOES)));
    public static final RegistryObject<Block> WATER_SPRING_BLOCK = BlockRegistry.register("water_spring_block", () -> new WaterSpringBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistryObject<Block> LAVA_SPRING_BLOCK = BlockRegistry.register("lava_spring_block", () -> new LavaSpringBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistryObject<Block> STEEL_BLOCK = BlockRegistry.register("steel_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));

    private static RegistryObject<Block> register(String id, Supplier<Block> block) {
        RegistryObject toReturn = BLOCKS.register(id, block);
        ItemRegistry.ITEMS.register(id, () -> new BlockItem((Block)toReturn.get(), new Item.Properties()));
        return toReturn;
    }

    public static void init() {
    }
}

