/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.registries;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.xstopho.resource_cracker.config.ToolConfig;
import net.xstopho.resource_cracker.item.ChiselItem;
import net.xstopho.resource_cracker.item.CrackHammerItem;
import net.xstopho.resource_cracker.item.ScytheItem;
import net.xstopho.resource_cracker.item.food.CrackerFoodProperties;
import net.xstopho.resource_cracker.item.tier.CrackerToolTier;
import net.xstopho.resource_cracker.registries.BlockRegistry;
import net.xstopho.resourcelibrary.registration.RegistryObject;
import net.xstopho.resourcelibrary.registration.RegistryProvider;

public class ItemRegistry {
    public static final RegistryProvider<Item> ITEMS = RegistryProvider.get((ResourceKey)Registries.ITEM, (String)"resource_cracker");
    public static final RegistryObject<Item> MATERIAL_DUST_COPPER = ItemRegistry.register("material_dust_copper");
    public static final RegistryObject<Item> MATERIAL_DUST_IRON = ItemRegistry.register("material_dust_iron");
    public static final RegistryObject<Item> MATERIAL_DUST_GOLD = ItemRegistry.register("material_dust_gold");
    public static final RegistryObject<Item> MATERIAL_DUST_EMERALD = ItemRegistry.register("material_dust_emerald");
    public static final RegistryObject<Item> MATERIAL_DUST_DIAMOND = ItemRegistry.register("material_dust_diamond");
    public static final RegistryObject<Item> MATERIAL_DUST_NETHERITE_SCRAP = ItemRegistry.register("material_dust_netherite_scrap");
    public static final RegistryObject<Item> MATERIAL_DUST_NETHERITE = ItemRegistry.register("material_dust_netherite");
    public static final RegistryObject<Item> MATERIAL_DUST_CARBON = ItemRegistry.register("material_dust_carbon");
    public static final RegistryObject<Item> MATERIAL_DUST_STEEL = ItemRegistry.register("material_dust_steel");
    public static final RegistryObject<Item> MATERIAL_DUST_SULFUR = ItemRegistry.register("material_dust_sulfur");
    public static final RegistryObject<Item> MATERIAL_DUST_SALTPETER = ItemRegistry.register("material_dust_saltpeter");
    public static final RegistryObject<Item> STEEL_INGOT = ItemRegistry.register("steel_ingot");
    public static final RegistryObject<Item> NUGGET_DIAMOND = ItemRegistry.register("nugget_diamond");
    public static final RegistryObject<Item> NUGGET_EMERALD = ItemRegistry.register("nugget_emerald");
    public static final RegistryObject<Item> NUGGET_COPPER = ItemRegistry.register("nugget_copper");
    public static final RegistryObject<Item> CRACK_HAMMER_COPPER = ItemRegistry.register("crack_hammer_copper", () -> new CrackHammerItem(() -> ToolConfig.copperHammer));
    public static final RegistryObject<Item> CRACK_HAMMER_GOLD = ItemRegistry.register("crack_hammer_gold", () -> new CrackHammerItem(() -> ToolConfig.goldHammer));
    public static final RegistryObject<Item> CRACK_HAMMER_IRON = ItemRegistry.register("crack_hammer_iron", () -> new CrackHammerItem(() -> ToolConfig.ironHammer));
    public static final RegistryObject<Item> CRACK_HAMMER_STEEL = ItemRegistry.register("crack_hammer_steel", () -> new CrackHammerItem(() -> ToolConfig.steelHammer));
    public static final RegistryObject<Item> CRACK_HAMMER_DIAMOND = ItemRegistry.register("crack_hammer_diamond", () -> new CrackHammerItem(() -> ToolConfig.diamondHammer));
    public static final RegistryObject<Item> CRACK_HAMMER_NETHERITE = ItemRegistry.register("crack_hammer_netherite", () -> new CrackHammerItem(() -> ToolConfig.netheriteHammer));
    public static final RegistryObject<Item> CHISEL_COPPER = ItemRegistry.register("chisel_copper", () -> new ChiselItem(() -> ToolConfig.copperChisel));
    public static final RegistryObject<Item> CHISEL_GOLD = ItemRegistry.register("chisel_gold", () -> new ChiselItem(() -> ToolConfig.goldChisel));
    public static final RegistryObject<Item> CHISEL_IRON = ItemRegistry.register("chisel_iron", () -> new ChiselItem(() -> ToolConfig.ironChisel));
    public static final RegistryObject<Item> CHISEL_STEEL = ItemRegistry.register("chisel_steel", () -> new ChiselItem(() -> ToolConfig.steelChisel));
    public static final RegistryObject<Item> CHISEL_DIAMOND = ItemRegistry.register("chisel_diamond", () -> new ChiselItem(() -> ToolConfig.diamondChisel));
    public static final RegistryObject<Item> CHISEL_NETHERITE = ItemRegistry.register("chisel_netherite", () -> new ChiselItem(() -> ToolConfig.netheriteChisel));
    public static final RegistryObject<Item> SCYTHE_COPPER = ItemRegistry.register("scythe_copper", () -> new ScytheItem((Tier)Tiers.GOLD, 2, -1.8f));
    public static final RegistryObject<Item> SCYTHE_GOLD = ItemRegistry.register("scythe_gold", () -> new ScytheItem((Tier)Tiers.GOLD, 3, -1.8f));
    public static final RegistryObject<Item> SCYTHE_IRON = ItemRegistry.register("scythe_iron", () -> new ScytheItem((Tier)Tiers.IRON, 3, -1.8f));
    public static final RegistryObject<Item> SCYTHE_STEEL = ItemRegistry.register("scythe_steel", () -> new ScytheItem(CrackerToolTier.STEEL, 3, -1.8f));
    public static final RegistryObject<Item> SCYTHE_DIAMOND = ItemRegistry.register("scythe_diamond", () -> new ScytheItem((Tier)Tiers.DIAMOND, 4, -1.8f));
    public static final RegistryObject<Item> SCYTHE_NETHERITE = ItemRegistry.register("scythe_netherite", () -> new ScytheItem((Tier)Tiers.NETHERITE, 5, -1.8f));
    public static final RegistryObject<Item> GARLIC = ItemRegistry.register("garlic", () -> new ItemNameBlockItem((Block)BlockRegistry.GARLIC_CROP.get(), new Item.Properties().food(CrackerFoodProperties.GARLIC)));
    public static final RegistryObject<Item> BEEF_JERKY = ItemRegistry.register("beef_jerky", () -> new Item(new Item.Properties().food(CrackerFoodProperties.BEEF_JERKY)));

    private static RegistryObject<Item> register(String id, Supplier<Item> item) {
        return ITEMS.register(id, item);
    }

    private static RegistryObject<Item> register(String id) {
        return ItemRegistry.register(id, () -> new Item(new Item.Properties()));
    }

    public static void init() {
    }
}

